### Computational requirements

Most of our runs are conducted on 3090/4090, and we recommend using similar devices.

For Atari, a GPU with memory >= 11GB is preferred.

For Hollow Knight, a GPU equal to or stronger than 3090 is required.

### Environment

Install: `pip install -r requirements.txt`

This should be sufficient for lunch Atari runs.

For Hollow Knight, `ray` is also required.
One needs to:
1. Configure a Windows virtual machine with Hollow Knight installed (or a real machine with a good network connection with the training node). We use Windows 10 with WSL as the host machine (training) and Hyper-V Windows as the virtual machine (game running).
2. Install `ray` on both the host and the virtual machine and ensure the version is the same. Install `opencv-python, mss, keyboard, numpy, pygetwindow` on the virtual machine.
3. Launch `StartRay.sh` on the host machine. Launch `start_ray.ps1` on the virutal machine (modify the conda env and ip to your configuration).
4. Lauch training at the host node as Atari games.


### Train and eval

Use `Exec.sh` to train/eval, use `Tensorbaord.sh` to see training curves, and use `Kill.sh` to kill the background training process.

First download `coco_lvis_h18_itermask.pth`, `cutie-small-mega.pth` to the `feature_extractor/cutie/weights` folder from https://github.com/hkchengrex/Cutie/releases/tag/v1.0

The `--config_name` in `Exec.sh` controls module options (Section 5.2), which can be found in the configs folder (the name of the files).

For Hollow Knight, we only keep annotations of `HornetProtector` and `MantisLords` to save storage. For evaluations on other bosses please refer to the provided video.