close all
clear all

n = 600;
lambda = 2800
T = 10000;
eta = 1/1800; %(2*lambda);
numExp = 10;
r = 1; 
sigma = 0.18*sqrt(n);
tau = n;


avg_signalToNoiseRatio = 0;
avg_errorInitial_LR = 0;
avg_numIterCondHolds_Z = 0;
avg_firstIterConditionHolds_Z = 0;
avg_numIterCondHolds_X = 0;
avg_firstIterConditionHolds_X = 0;
avg_rank_ergodic = 0;
avg_error_ergodic = 0;
avg_gap_ergodic = 0;
avg_dual_gap_ergodic = 0;
avg_minDualGap = 0;
avg_error_dualGapMin = 0;
avg_gap_dualGapMin = 0;
avg_dual_gap_dualGapMin = 0;
avg_errorInitial_projected = 0;
avg_error_projected = 0;
avg_fisibility = 0;
avg_fisibilityInitial = 0;

for k = 1:numExp
    
    arguments = 2*pi*rand(n,1);
    z0 = cos(arguments)+i*sin(arguments);
    P = z0*z0';
    
    N = sigma*(randn(n,n)+i*randn(n,n));
    N = triu(N,1);
    N = N+N';

    M = (z0*z0') + N; 
    rSVD = r;
     
    signalToNoiseRatio = norm((z0*z0'),'fro')^2/norm(N,'fro')^2;
    avg_signalToNoiseRatio = avg_signalToNoiseRatio + signalToNoiseRatio/numExp;
   
    
    % EXTRA-GRADIENT
    
    [U,S] = eigs(M,1,'largestreal'); %low rank approximation
    X = tau*(U*U');
    X_dualGapMin = X;
    X_initial = X;
    
    y = (diag(X)-ones(n,1))/norm(diag(X)-ones(n,1));
    y_dualGapMin = y;
    
    
    [Ux,Sx] = eigs(-M+lambda*diag(y),1,'smallestreal');
    grad_y = lambda*(diag(X)-ones(n,1));
    dual_gapX_dualGapMin = trace((X-tau*(Ux*Ux'))'*(-M+lambda*diag(y)));
    dual_gapY_dualGapMin = (y-(grad_y/norm(grad_y)))'*grad_y;
    minDualGap = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
    
    errorInitial_LR = norm((trace(z0*z0')/tau)*X-(z0*z0'),'fro')^2 / norm(z0*z0','fro')^2;
    avg_errorInitial_LR = avg_errorInitial_LR + errorInitial_LR ./ numExp;
    
    for l = 1:n
        for j = 1:n
            X_initial(l,j) =  X_initial(l,j)/norm(X_initial(l,j));
        end
    end
    errorInitial_projected = norm((trace(z0*z0')/tau)*X_initial-(z0*z0'),'fro')^2 / norm(z0*z0','fro')^2;
    avg_errorInitial_projected = avg_errorInitial_projected + errorInitial_projected ./ numExp;
    
    avg_fisibilityInitial = avg_fisibilityInitial + norm(diag(X)-ones(n,1))/numExp;
    
    checkCondition_Z = zeros(T,1);
    checkCondition_X = zeros(T,1); 
    Z_ergodic = zeros(n);
    w_ergodic = zeros(n,1);
    
    for t = 1:T
        
        grad_X = -M+lambda*diag(y);
        [U,S] = eigs(X-eta*grad_X,rSVD+1,'largestreal');
        eigens = projsplx(diag(S(1:rSVD,1:rSVD)),tau);
        Z = U(:,1:rSVD)*diag(eigens)*U(:,1:rSVD)';
        
        if sum(diag(S(1:rSVD,1:rSVD))) >= tau+rSVD*S(rSVD+1,rSVD+1)
            checkCondition_Z(t) = 1;
        end
        
        Z_ergodic = Z_ergodic + Z/T;
        
        grad_y = lambda*(diag(X)-ones(n,1));
        w = y + eta*grad_y;
        if norm(w) > 1
            w = w/norm(w);
        end
        
        w_ergodic = w_ergodic + w/T;
        
        grad_Z = -M+lambda*diag(w);
        [U,S] = eigs(X-eta*grad_Z,rSVD+1,'largestreal');
        eigens = projsplx(diag(S(1:rSVD,1:rSVD)),tau);
        X = U(:,1:rSVD)*diag(eigens)*U(:,1:rSVD)';
        
        if sum(diag(S(1:rSVD,1:rSVD))) >= tau+rSVD*S(rSVD+1,rSVD+1)
            checkCondition_X(t) = 1;
        end
        
        grad_w = lambda*(diag(Z)-ones(n,1));
        y = y + eta*grad_w;
        if norm(y) > 1
            y = y/norm(y);
        end
        
        [U2,S2] = eigs(grad_X,1,'smallestreal');
        dual_gapX_dualGapMin = trace((X-tau*(U2*U2'))'*grad_X);
        dual_gapY_dualGapMin = (y-(grad_y/norm(grad_y)))'*grad_y;
        dual_gap_dualGapMin = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
        if dual_gap_dualGapMin < minDualGap
            minDualGap = dual_gap_dualGapMin;
            X_dualGapMin = X;
            y_dualGapMin = y;
        end
        
        [U2,S2] = eigs(grad_Z,1,'smallestreal');
        dual_gapX_dualGapMin = trace((Z-tau*(U2*U2'))'*grad_Z);
        dual_gapY_dualGapMin = (w-(grad_w/norm(grad_w)))'*grad_w;
        dual_gap_dualGapMin = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
        if dual_gap_dualGapMin < minDualGap
            minDualGap = dual_gap_dualGapMin;
            X_dualGapMin = Z;
            y_dualGapMin = w;
        end
        
    end
    
    numIterCondHolds_Z = nnz(checkCondition_Z);
    avg_numIterCondHolds_Z = avg_numIterCondHolds_Z + numIterCondHolds_Z ./ numExp;
    firstIterConditionHolds_Z = find(checkCondition_Z,1,'first');
    avg_firstIterConditionHolds_Z = avg_firstIterConditionHolds_Z +firstIterConditionHolds_Z/numExp;
    
    numIterCondHolds_X = nnz(checkCondition_X);
    avg_numIterCondHolds_X = avg_numIterCondHolds_X + numIterCondHolds_X ./ numExp;
    firstIterConditionHolds_X = find(checkCondition_X,1,'first');
    avg_firstIterConditionHolds_X = avg_firstIterConditionHolds_X +firstIterConditionHolds_X/numExp;
    
    error_ergodic = norm((trace(z0*z0')/tau)*Z_ergodic-(z0*z0'),'fro')^2 / norm(z0*z0','fro')^2;
    avg_error_ergodic = avg_error_ergodic + error_ergodic ./ numExp;
    
    error_dualGapMin = norm((trace(z0*z0')/tau)*X_dualGapMin-(z0*z0'),'fro')^2 / norm(z0*z0','fro')^2;
    avg_error_dualGapMin = avg_error_dualGapMin + error_dualGapMin ./ numExp;
    
    X_projected = X_dualGapMin;
    for l = 1:n
        for j = 1:n
            X_projected(l,j) =  X_projected(l,j)/norm(X_projected(l,j));
        end
    end
    error_projected = norm((trace(z0*z0')/tau)*X_projected-(z0*z0'),'fro')^2 / norm(z0*z0','fro')^2;
    avg_error_projected = avg_error_projected + error_projected ./ numExp;
    
    rank_ergodic = rank(Z_ergodic);
    avg_rank_ergodic = avg_rank_ergodic + rank_ergodic ./ numExp;
    
    [U1,S1] = eigs(-(-M+lambda*diag(w_ergodic)),rSVD+1,'largestreal');
    gap_ergodic = S1(rSVD,rSVD) - S1(rSVD+1,rSVD+1);
    avg_gap_ergodic = avg_gap_ergodic + gap_ergodic ./ numExp;
    
    grad_w_ergodic = lambda*(diag(Z_ergodic)-ones(n,1));
    dual_gapX_ergodic = trace((Z_ergodic-tau*(U1(:,1)*U1(:,1)'))'*(-M+lambda*diag(w_ergodic)));
    dual_gapY_ergodic = (w_ergodic-(grad_w_ergodic/norm(grad_w_ergodic)))'*grad_w_ergodic;
    dual_gap_ergodic = dual_gapX_ergodic - dual_gapY_ergodic;
    avg_dual_gap_ergodic = avg_dual_gap_ergodic + dual_gap_ergodic/numExp;
    
    [U2,S2] = eigs(-(-M+lambda*diag(y_dualGapMin)),rSVD+1,'largestreal');
    gap_minDualGap = S2(rSVD,rSVD) - S2(rSVD+1,rSVD+1);
    avg_gap_dualGapMin = avg_gap_dualGapMin + gap_minDualGap ./ numExp;
    
    grad_y_dualGapMin = lambda*(diag(X_dualGapMin)-ones(n,1));
    dual_gapX_dualGapMin = trace((X_dualGapMin-tau*(U2(:,1)*U2(:,1)'))'*(-M+lambda*diag(y_dualGapMin)));
    dual_gapY_dualGapMin = (y_dualGapMin-(grad_y_dualGapMin/norm(grad_y_dualGapMin)))'*grad_y_dualGapMin;
    dual_gap_dualGapMin = dual_gapX_dualGapMin - dual_gapY_dualGapMin;
    avg_dual_gap_dualGapMin = avg_dual_gap_dualGapMin + dual_gap_dualGapMin/numExp;
    
    avg_fisibility = avg_fisibility + norm(diag(X_dualGapMin)-ones(n,1))/numExp;
    
end

    
avg_signalToNoiseRatio
avg_errorInitial_LR
avg_numIterCondHolds_Z
avg_firstIterConditionHolds_Z
avg_numIterCondHolds_X
avg_firstIterConditionHolds_X
avg_error_dualGapMin
avg_gap_dualGapMin
avg_dual_gap_dualGapMin
avg_fisibility