import json
import os
from pathlib import Path


# SSWIM

def export(name,
           results_dir,
           dataset,
           seeds,
           data_norm,
           horizon,
           n_hidden,
           sample_kernel,
           objective,
           normaliser,
           size_init_batch,
           batch_size,
           metrics,
           reg
           ):
    experiments_dir = Path(__file__).resolve().parent / f"configs_{dataset}"
    experiments_dir.mkdir(parents=True, exist_ok=True)
    data_dict = {
        "dataset": dataset,
        "horizon": horizon,
        "seeds": seeds,
        "data_norm": data_norm,
    }
    model_dict = {
        "n_hidden": n_hidden,
        "sample_kernel": sample_kernel,
        "objective": objective,
        "normaliser": normaliser,
    }
    train_dict = {
        "size_init_batch": size_init_batch,
        "batch_size": batch_size,
        "reg": reg,
        "metrics": metrics,
    }
    config = {
        "name": name,
        "results_dir": results_dir,
        "data": data_dict,
        "model": model_dict,
        "train": train_dict,
    }
    with open(os.path.join(experiments_dir, name + ".json"), "w") as f:
        json.dump(config, f)

RESULTS_DIR = "results"

for sample_kernel in ["hat", "morlet"]:
    for dataset in ["solar", "electricity", "metr-la", "pems-bay"]:
        for horizon in [6, 24, 48, 96]:
            export(
                name=f"{dataset}_{sample_kernel}_{horizon}",
                results_dir = RESULTS_DIR,
                dataset=dataset,
                seeds=[0, 42, 100],
                data_norm="zero_one",
                horizon=horizon,
                sample_kernel=sample_kernel,
                n_hidden=750,
                objective="dot",
                normaliser=("MS", 0.5, 0.5),
                metrics="best",
                reg=-1,
                size_init_batch=1000,
                batch_size=1000 if dataset != "electricity" else 700,
            )
