#!/usr/bin/env bash
set -euo pipefail
shopt -s nullglob

# Help message if not enough arguments
if [[ $# -lt 3 ]]; then
  cat <<'USAGE' >&2
Usage: ./run_selected_configs.sh PYTHONPATH PYTHON_EXECUTABLE CUDA_VISIBLE_DEVICES EXP_SCRIPT RESULTS_DIR CONFIG_DIR [CONFIG_DIR2 ...]

Calls the supplied EXP_SCRIPT for all JSON files in the specified CONFIG_DIR(s) using the given PYTHON_EXECUTABLE.
Results for each run are written to the given RESULTS_DIR

Example:
  ./run_selected_configs.sh PYTHONPATH=~ ~/python_cupy 0 run_experiment.py results config_a config_b
USAGE
  exit 1
fi

export PYTHONPATH="$1"
shift

export PYTHON_EXECUTABLE="$1"
shift

export CUDA_VISIBLE_DEVICES="$1"
shift # Remove CUDA argument

EXP_SCRIPT=$1
shift


RESULTS_DIR=$1
shift

for cfgdir in "$@"; do
  if [[ ! -d "$cfgdir" ]]; then
    echo "Warning: Directory '$cfgdir' not found, skipping." >&2
    continue
  fi

  for config in "$cfgdir"/*.json; do
    [[ -e "$config" ]] || continue

    name=$(basename "$config" .json)
    cfgparent=$(basename "$cfgdir")

    RES_EXP="$RESULTS_DIR/${name}"
    mkdir -p "$RES_EXP"

    echo "Starting config=${cfgparent}/${name} (CUDA_VISIBLE_DEVICES=${CUDA_VISIBLE_DEVICES})"
    $PYTHON_EXECUTABLE "$EXP_SCRIPT" "$config" > "$RES_EXP"/log.txt && rm "$config"
  done
done

echo "All done."
