import json
import os
from pathlib import Path

# SGD Finetuning

def export(name,
           dataset,
           seeds,
           horizon,
           n_hidden,
           sample_kernel,
           batch_size,
           initial_lr,
           num_epochs,
           patience,
           min_delta,
           final_lr,
           ):
    experiments_dir = Path(__file__).resolve().parent / f"configs_{dataset}"
    experiments_dir.mkdir(parents=True, exist_ok=True)
    data_dict = {
        "dataset": dataset,
        "horizon": horizon,
        "seeds": seeds,
    }
    model_dict = {
        "n_hidden": n_hidden,
        "sample_kernel": sample_kernel,
    }
    train_dict = {
        "batch_size": batch_size,
        "initial_lr": initial_lr,
        "num_epochs": num_epochs,
        "patience": patience,
        "min_delta": min_delta,
        "final_lr": final_lr,
    }
    config = {
        "name": name,
        "data": data_dict,
        "model": model_dict,
        "train": train_dict,
    }
    with open(os.path.join(experiments_dir, name + ".json"), "w") as f:
        json.dump(config, f)

for sample_kernel in ["hat", "morlet"]:
    for dataset in ["solar", "electricity", "metr-la", "pems-bay"]:
        for horizon in [6, 24, 48, 96]:
            export(
                name=f"{dataset}_{sample_kernel}_{horizon}",
                dataset=dataset,
                seeds=[0, 42, 100],
                horizon=horizon,
                sample_kernel=sample_kernel,
                n_hidden=750,
                batch_size=64,
                initial_lr=2.5e-4,
                num_epochs=250,
                patience=30,
                min_delta=1e-6,
                final_lr=1e-05,
            )
