# Code for the sswim algorithm (ICLR 2026 submission "Random feature spiking neural networks")
## Important files
- Experiments
  - Contains the code to run the experiments for sswim-only, sgd-only and sswim + sgd finetuning.
  - Each subfolder contains a ```make_config.py```, which generates the config file for the experiments in the paper
  - Each subfolder contains a ```run_experiments.py```, which is called by the ```run_experiments.sh``` script.
  - After generating the configs, ```run_experiments.sh``` can be used to run the experiments.
    - The script contains calling instructions.
  - The sswim-only experiments are run with the Cupy environment.
  - The sgd-only and sswim + sgd finetuning experiments are run with the Lava-DL environment.
- Datasets
  - Contains the raw datasets as .zip. Unzip in the current location for running the experiments.
  - Other files are helpers, containing the specific preprocessing for the datasets as described in the paper.
- model
  - Contains the CuPy implementation of the neuron model and most steps S-SWIM in ```model/layer/srm_layer_fixed.py```.
- slayer_model
  - Contains the respective Lava-DL / Pytorch implementation for the gradient-based experiments. 
## S-SWIM algorithm
- The hidden layer temporal parameters step can be found in the `run_experiments.py` file in `Experiments/sswim/run_experiments.py`.
- The main code for the sampling step is in `utilts/metrics/calibrate_sampling.py`, `utilts/metrics/sample.py`, and `utilts/metrics/sampling_metrics.py`
- The weight construction, normalisation, and outpul layer delays, kernel supports and linear solve steps are found in `model/layer/srm_layer_fixed.py`
## Setup:
- Unzip the datasets in the `datasets` directory.
- Set the correct `NVCC` path in `.env`.
- Setup Conda environments
```bash
# Cupy
conda env create -f conda_envs/cupy_env.yml

# Lava-DL
conda env create -f conda_envs/laval_env.yml
```
# Note
The code requires an NVIDIA GPU to run. All experiments can be run on a single GPU with 10 GB of memory.