import numpy as np

def z_score(data):
    return (data - data.mean(axis=-1, keepdims=True)) / data.std(axis=-1, keepdims=True)

def zero_one(data):
    mins = np.min(data, axis=1, keepdims=True)  # Minimum value for each variable
    maxs = np.max(data, axis=1, keepdims=True)  # Maximum value for each variable
    ranges = maxs - mins

    # Avoid division by zero
    ranges = np.where(ranges == 0, 1, ranges)

    # Normalize data to [0, 1]
    data_normalized = (data - mins) / ranges

    return data_normalized