import cupy as cp

class Normaliser:
    def __init__(self):
        pass

    def __call__(self, w, means, stds, dtype=cp.float32):
        return cp.full_like(means, 1, dtype=dtype), cp.full_like(means, 0, dtype=dtype), cp.full_like(means, -1, dtype=dtype)

class MeanStd(Normaliser):
    def __init__(self, mu=0.5, sig=0.5):
        self.mu = mu
        self.sig = sig
        super().__init__()

    def __call__(self, w, means, stds, dtype=cp.float32):
        alphas = (self.sig / stds).astype(dtype)
        bias = (self.mu - means * alphas).astype(dtype)
        out_weights = cp.full_like(means, -3 * self.sig, dtype=dtype)
        return alphas, bias, out_weights

class Fluct(Normaliser):
    def __init__(self, c=1):
        super().__init__()
        self.c = c

    def __call__(self, w, means, stds, dtype=cp.float32):
        alphas = cp.full_like(means, 1, dtype=dtype)
        bias = (1 - self.c * stds - means).astype(dtype)
        out_weights = (-3 * stds).astype(dtype)
        return alphas, bias, out_weights

