from BACKEND import cp, np
import torch

def torch_to_cupy(tensor: torch.Tensor) -> cp.ndarray:
    if tensor.is_cuda:
        return cp.from_dlpack(tensor.detach())
    else:
        return cp.array(np.from_dlpack(tensor.detach()))

def cupy_to_torch(tensor: cp.ndarray) -> torch.Tensor:
    return torch.utils.dlpack.from_dlpack(tensor.toDlpack())