import torch

def sp(param, alpha=5, min_value=0.):
    return torch.log(1 + torch.exp(alpha * param)) / alpha + min_value

def inv_sp(param_eff, alpha=5, min_value=0.):
    if not isinstance(param_eff, torch.Tensor):
        param_eff = torch.tensor(param_eff)
    return torch.log(torch.exp(alpha * (param_eff - min_value)) - 1) / alpha