import asyncio
from googletrans import Translator


async def translate_text(text, dest='ja'):
    async with Translator() as translator:
        result = await translator.translate(text, dest)
    return result

async def detect_lang(text):
    async with Translator() as translator:
        result = await translator.detect(text)
        return result

def translate(text, dest='ja'):
    try: 
        text = asyncio.run(translate_text(text, dest)).text
    except:
        print("Translation failed")
    return text
