# The Power of Noise: Redefining Retrieval for RAG Systems

This repository contains the code and data to reproduce the experiments from the paper [The Power of Noise: Redefining Retrieval for RAG Systems](https://arxiv.org/abs/2401.14887).

## Installation

1. Set up a conda environment.

```
conda create -n power_of_noise python=3.9 --yes
conda activate power_of_noise
```

2. Install package and requirements.

```
pip install -r requirements.txt
```

## Data
The corpus and NQ datasets can be downloaded from HuggingFace using the code in the respective sections.

The full training set was not used for the experiments; instead, a smaller sample of 10K entries was employed, and is available in the `data` folder of this repository. For the experiments described in the "RAG in Practice" section, the test set was utilized.

Data not present in this repository or not downloadable from HuggingFace can be found in this [Google Drive](https://drive.google.com/drive/folders/1MfR7mJ76tyVpjbMwUkMVbEjOQKpdL-Lq?usp=sharing).


### Corpus

- **Original Source**: The corpus originates from the English Wikipedia (Dec. 20, 2018), where each document is segmented into non-overlapping passages of 100 words. The original corpus can be downloaded from this [link](https://dl.fbaipublicfiles.com/dpr/wikipedia_split/psgs_w100.tsv.gz).

- **Processing**: We integrated gold documents from the [NQ dataset](https://ai.google.com/research/NaturalQuestions) in the corpus, applying duplicate filtering for precise query-document matching. Documents exceeding 512 tokens (tokenized with Llama2) were excluded to maintain manageable input sizes for LLMs, resulting in a final corpus of 21,035,236 documents.

The processed dataset is available on HuggingFace:
```
from datasets import load_dataset
corpus = load_dataset('florin-hf/wiki_dump2018_nq_open')
```


An example of a Wikipedia passage is as follows:
```
{
  "text": Home computers were a class of microcomputers entering the market in 1977, and becoming common during the 1980s.
          They were marketed to consumers as affordable and accessible computers that, for the first time, were intended for the use of a single nontechnical user.
          These computers were a distinct market segment that typically cost much less than business,
          scientific or engineering-oriented computers of the time such as the IBM PC, and were generally less powerful in terms of memory and expandability.
          However, a home computer often had better graphics and sound than contemporary business computers. Their most common uses were playing
  "title": "Home computer"
}
```

#### Subsets of the Corpus 
Considering the substantial memory requirements (~25Gb) for loading the entire corpus, we provide subsets tailored to specific experiments, reducing the RAM footprint.

A subset contains only the documents present in the search results by the retrievers or by random sampling for a the specific configuration (see **Generation** section). In this way, when running the generation, it is not needed to load the entire corpus in RAM, but only the documents that could possibly be included in the prompt of the LLMs. 

These subsets can be found in the Google Drive under the folder `data/processed`. 


### Natural Questions

The NQ dataset, curated to exclude entries with gold documents over 512 tokens, includes 72,209 training and 2,889 test examples. In these experiments, the validation set was not used, but can be downloaded along with the other splits from HuggingFace:
```
from datasets import load_dataset
dataset = load_dataset('florin-hf/nq_open_gold')
```

A sample in the dataset has the following format:
```
{
    'example_id' (int64): an identifier for the question, consistent with the original NQ dataset,
    'question' (str): a question, that is identical to the question in the original NQ,
    'answers' (List[str]): the list of correct answers in the original NQ,
    'text' (str): gold document, associated with the question, in the original NQ,
    'idx_gold_in_corpus' (int64): index of the gold document in the full corpus.
}

Ex.
{
    'example_id': -3440030035760311385,
    'question': 'who owned the millennium falcon before han solo',
    'answers': [Lando Calrissian],
    'text': "Han Solo won the Millennium Falcon from Lando Calrissian in the card game ' sabacc ' several years before the events of the film A New Hope..."
    'idx_gold_in_corpus': 20995349
}
```

## RAG Steps

### 1. Retrieval

In the first phase of a RAG system, a retriever is employed to search the top-ranked documents based on a given similarity metric. In these experiments three different retrievers were used: Contriever, ADORE and BM25. The search results of the three models are presented in the data folder (e.g., `data/contriever_search_results_at150.pkl`). Each result is a tuple containing in the first position the indices of the top-ranked documents in the corpus; and as second position their corresponding scores. In the case of dense retriever, an Inner Product (IP) search was adopted, thus the higher the score the closer the embeddings in the vector space.

The following three steps were used to compute search results for a dense retriever:
##### 1. Compute Corpus Embeddings
The `compute_corpus_embeddings.py` script computes embeddings in batches, storing them in the `output_dir`.

##### 2. Index Embeddings:
The `index_embeddings.py` script concatenates the piecewise stored embeddings and creates the index.
- Single Index: Leave `percentages_for_index_splitting` empty.
- Multiple Indices: Specify splitting percentages to create multiple indices that can be loaded into different GPUs.

##### 3. Retrieve Top-k Documents
The `compute_search_results.py` script retrieves the top-k documents for the given queries using the FAISS index/indices created earlier.

### 2. Generation

```
python src/generate_answers_llm.py \
    --llm_id meta-llama/Llama-2-13b-chat-hf \
    --num_documents_in_context 3 \
    --get_documents_without_answer True \
    --use_check_point False \
    --reverse True;
```
This code generates dataset of 2 distraction documents and 1 relevant document.