from transformers import AutoTokenizer, AutoModelForSeq2SeqLM, AutoModelForCausalLM, default_data_collator, get_linear_schedule_with_warmup
from peft import get_peft_config, get_peft_model, get_peft_model_state_dict, PrefixTuningConfig, TaskType,PeftModelForCausalLM
from Rpeft_model import RPeftModel
from datasets import load_dataset
from torch.utils.data import DataLoader
from tqdm import tqdm
import torch
import argparse
import os
from trl import SFTTrainer
from transformers import (
    AutoModelForCausalLM,
    BitsAndBytesConfig,
    AutoTokenizer,
    TrainingArguments,
    AutoConfig
)
from transformers import TrainerCallback, TrainerState, TrainerControl

class MiniBatchCallback(TrainerCallback):
    def on_step_end(self, args, state: TrainerState, control: TrainerControl, **kwargs):
        # 打印当前step的loss
        # print(args)
        # print(state)
        # print(control)
        # print(kwargs)
        if len(state.log_history)==0:
            return
        if 'loss' in state.log_history[-1]:  # 确保有loss信息
            print(f"Step: {state.global_step}, Loss: {state.log_history[-1]['loss']}")
            

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "--base_model_name",
        type=str,
        default="meta-llama/Llama-2-7b-chat-hf",
    )
    parser.add_argument(
        "--dataset_name",
        type=str,
        default="gold_only",
    )
    parser.add_argument(
        "--output_dir",
        type=str,
        default="nq_no_ret",
    )
    parser.add_argument(
        "--seed",
        type=int,
        default=1,
    )
    parser.add_argument(
        "--percentage",
        type=float,
        default=0.1,
    )
    parser.add_argument(
        "--num_virtual_token",
        type=int,
        default=5,
    )
    return parser.parse_args()

args=parse_args()
args.output_dir=f'/home/somebody/codes/RAGE/RPrefix_tuning/checkpoints_prefix/{args.dataset_name}/virtual_token_{args.num_virtual_token}/percentage_{args.percentage}'

if not os.path.exists(args.output_dir):
    os.makedirs(args.output_dir)
os.environ["TOKENIZERS_PARALLELISM"] = "false"
os.environ["CUDA_VISIBLE_DEVICES"] = "0,1"
os.environ['CUDA_LAUNCH_BLOCKING']="1"

model_name_or_path = args.base_model_name
tokenizer_name_or_path = model_name_or_path

text_column = "prompt"
label_column = "completion"
max_length = 1024
lr = 1e-5
num_epochs = 5
batch_size = 4

dataset_name=args.dataset_name
from datasets import load_dataset
# dataset = load_dataset("financial_phrasebank", "sentences_allagree")
# dataset = dataset["train"].train_test_split(test_size=0.1)
# dataset["validation"] = dataset["test"]
# del dataset["test"]

tokenizer = AutoTokenizer.from_pretrained(model_name_or_path)
tokenizer.pad_token = tokenizer.eos_token 
    
train_file=os.path.join(f'prompt_answer/train',dataset_name)+".json"
test_file=os.path.join(f'prompt_answer/test',dataset_name)+".json"
print(train_file)
print(test_file)
train_dataset = load_dataset('json',data_files={"train":train_file,"test":test_file},split='train')
test_dataset = load_dataset('json',data_files={"train":train_file,"test":test_file},split='test')
def preprocess_function(examples):
    inputs = examples[text_column]
    targets = examples[label_column]
    model_inputs = tokenizer(inputs, max_length=max_length, padding="max_length", truncation=True, return_tensors="pt")
    labels = tokenizer(targets, max_length=32, padding="max_length", truncation=True, return_tensors="pt")
    labels = labels["input_ids"]
    labels[labels == tokenizer.pad_token_id] = -100
    model_inputs["labels"] = labels
    return model_inputs
train_processed_datasets = train_dataset.map(
    preprocess_function,
    batched=True,
    num_proc=1,
    remove_columns=train_dataset.column_names,
    load_from_cache_file=False,
    desc="Running tokenizer on dataset",
)
test_processed_datasets = test_dataset.map(
    preprocess_function,
    batched=True,
    num_proc=1,
    remove_columns=test_dataset.column_names,
    load_from_cache_file=False,
    desc="Running tokenizer on dataset",
)
train_dataloader = DataLoader(
    train_processed_datasets, shuffle=True, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=True
)
eval_dataloader = DataLoader(test_processed_datasets, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=True)

peft_config = PrefixTuningConfig(task_type='retrieval', inference_mode=False, num_virtual_tokens=args.num_virtual_token,prefix_projection=True)
bnb_config = BitsAndBytesConfig(
    load_in_4bit=True,
    bnb_4bit_quant_type="nf4",
    bnb_4bit_compute_dtype=torch.bfloat16,
)
model_config = AutoConfig.from_pretrained(model_name_or_path, trust_remote_code=True)
model = AutoModelForCausalLM.from_pretrained(
    model_name_or_path,
    trust_remote_code=True,
    config=model_config,
    quantization_config=bnb_config,
    torch_dtype=torch.bfloat16,
    device_map='auto',
)
model=RPeftModel(model, peft_config, percentage=args.percentage, adapter_name='default', autocast_adapter_dtype=True)
model.print_trainable_parameters()
optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=0,
    num_training_steps=(len(train_dataloader) * num_epochs),
)


for epoch in range(num_epochs):
    model.train()
    total_loss = 0
    for step, batch in enumerate(tqdm(train_dataloader)):
        
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().float()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        print("loss==",loss)
        pred=tokenizer.batch_decode(torch.argmax(outputs.logits, -1).detach().cpu().numpy(), skip_special_tokens=True)
        print('pred==',pred)
    model.eval()
    eval_loss = 0
    eval_preds = []
    for step, batch in enumerate(tqdm(eval_dataloader)):
        with torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().float()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -1).detach().cpu().numpy(), skip_special_tokens=True)
        )

    eval_epoch_loss = eval_loss / len(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / len(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    print(f"{epoch=}: {train_ppl=} {train_epoch_loss=} {eval_ppl=} {eval_epoch_loss=}")
