import numpy as np
import numpy.linalg as LA

from softmatcha.typing import Vector


def normalize(x: Vector, axis: int = -1, eps: float = 1e-12) -> Vector:
    """Normalize the input vectors by its norm.

    Args:
        x (Vector): Input vectors.
        axis (int): The axis of `x` along which to compute the vector norms.
        eps (float): Epsilon for the numerical stability.
    """
    return (x / (LA.norm(x, axis=axis, keepdims=True) + eps)).astype(np.float32)
