from dataclasses import dataclass

from softmatcha.typing import Vector


@dataclass
class TokenEmbeddings:
    """TokenEmbeddings stores a sequence of tokens and their embedding vectors.

    tokens (list[int]): A sequence of tokens.
    embeddings (Vector): D-dimensional embedding vectors of tokens of shape `(L, D)`,
      where `L` indicates the sequence length.
    """

    tokens: list[int]
    embeddings: Vector

    def __len__(self) -> int:
        return len(self.tokens)
