from __future__ import annotations

from . import register
from .base import Tokenizer


@register("gensim")
class TokenizerGensim(Tokenizer):
    """TokenizerFasttext class."""

    @property
    def unk_idx(self) -> int:
        """Return the unknown index."""
        return self.dictionary[self.UNK_TOKEN]

    @classmethod
    def build(cls, name_or_path: str) -> Tokenizer:
        """Build an tokenizer class.

        Args:
            name_or_path (str): Model name or path.

        Returns:
            Tokenizer: This class.
        """
        from softmatcha.tokenizers.moses import TokenizerMoses
        from softmatcha.utils import gensim as gensim_utils

        tokenizer = TokenizerMoses.build(
            gensim_utils.download_gensim_model(name_or_path)
        )
        return tokenizer
