import math
import scipy
import numpy as np



def get_montecarlo_accuracy(total_number_of_votes_allowed: int ,
                            candidate_probability_vector: list = [0.1, 0.2, 0.7],
                            truth_index = 0,
                            K: int = 100):
    win_rate_at_v = 0
    for k in range(K):
        rng = np.random.default_rng()
        samples = rng.multinomial(total_number_of_votes_allowed, candidate_probability_vector, size=1)
        winning_cs = np.flatnonzero(samples == np.max(samples))
        win = 0
        if winning_cs.size == 1:
            winning_c = np.argmax(samples)
            if winning_c == truth_index:
                win = 1

        win_rate_at_v += win

    return win_rate_at_v / K

def get_analytical_accuracy(candidate_probability_vector,
                            total_number_of_votes_allowed: int,
                            truth_index:int) -> float:
    if candidate_probability_vector[truth_index] == 0.0:
        p_star = 0.0
    else:
        E_truth = total_number_of_votes_allowed * candidate_probability_vector[truth_index]
        Var_truth = E_truth * (1 - candidate_probability_vector[truth_index])

        p_star = 1.0
        for y in range(len(candidate_probability_vector)):
            if y == truth_index:
                continue
            E_y = total_number_of_votes_allowed * candidate_probability_vector[y]
            Var_y = E_y * (1 - candidate_probability_vector[y])
            numerator = E_truth - E_y
            denominator = math.sqrt(Var_truth + Var_y)
            z_score = numerator / denominator
            p_truth_exceeds_y = scipy.stats.norm.cdf(z_score)
            p_star *= p_truth_exceeds_y

    return p_star

