import argparse
import os
import sys

import drexo

def null_callback(ret=None):
    return None

def run_multi(files, poll_interval=180, n_gpus=1):
    runner = drexo.RunnerEngine(resource_poll_interval=poll_interval, gpu_block_filename='/tmp/drexo_block_gpus')

    local_output_dir = '/tmp/tmpdrexo'
    os.makedirs(local_output_dir, exist_ok=True)
    for filename in files:
        runconfig = drexo.RunConfig(['bash', filename], local_output_dir, null_callback, requested_resources=[{'type': 'gpu', 'allow_sharing': False} for _ in range(n_gpus)])
        runner.add_job(runconfig)

    print('queued jobs, running...')
    runner.run()
    print('Done running jobs')


def main(args):
    run_multi(args.files, poll_interval=args.poll_interval, n_gpus=args.n_gpus)

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('files', nargs='+')
    parser.add_argument('--poll_interval', type=int, default=180)
    parser.add_argument('--n_gpus', type=int, default=1)
    args = parser.parse_args(sys.argv[1:])
    main(args)

