# read all folder under file_name
import os
import json
import numpy as np
from datetime import datetime
import matplotlib.pyplot as plt

import argparse
parser = argparse.ArgumentParser()
parser.add_argument('--file_path', type=str, default="", help='where to save the trajectory')
args = parser.parse_args()


folder_name = os.path.join(args.file_path, "history")

folder_list = os.listdir(folder_name)

# folder list sort by time stamp, folder named like 2025-04-09_06-59-39_naive__projects_befo_wchen11_0408-RWR-04_checkpoint
def extract_timestamp(folder_name):
    try:
        timestamp_str = folder_name.split('_naive')[0]  # Get the timestamp part
        return datetime.strptime(timestamp_str, '%Y-%m-%d_%H-%M-%S')
    except Exception as e:
        print(f"Error parsing timestamp from {folder_name}: {e}")
        return datetime.min  # Fallback to very old time if parse fails

# Sort folders by extracted timestamp
sorted_folders = sorted(folder_list, key=extract_timestamp)

all_win_rate = []
all_win_rate_std = []
for folder in sorted_folders:
    file_name = os.path.join(folder_name, folder, "summary.json")
    try:
        with open(file_name, "r") as f:
            data = json.load(f)
        win_rate = data["average_progress"]
        win_rate_std = data["standard_error"]
        all_win_rate.append(win_rate)
        all_win_rate_std.append(win_rate_std)
    except Exception as e:
        print(f"Error reading {file_name}: {e}")
        continue
print(all_win_rate)

# plot all win rate
plt.figure(figsize=(10, 5))
plt.title("Win Rate")
plt.xlabel("Epoch")
plt.ylabel("Win Rate")
plt.plot(all_win_rate, label="RWR")
plt.fill_between(range(len(all_win_rate)),
                 np.array(all_win_rate) - np.array(all_win_rate_std),
                 np.array(all_win_rate) + np.array(all_win_rate_std),
                 alpha=0.2, label="Standard Deviation")
plt.legend()
plt.savefig(args.file_path + "/win_rate.png")
    