import logging

# Register available models by importing them
from models.singular_2d import Singular2D
from models.trained2d import Trained2D
from models.trained_images import TrainedImage
from models.half_moons import HalfMoons

from models.base_sampler import MODELS

logger = logging.getLogger('LOG')

def validate_args(**kwargs):
    if not kwargs['model'] in MODELS:
        errs = f"Invalid model specifications. model must be one of {MODELS}"
        logger.debug(errs)
        raise ValueError(errs)
    
def sample_backward(model, N, T, 
                    n_samples = 1, 
                    n_noise_realizations = 1, 
                    perturb_size = 0.0, 
                    calculate_lyap = True,
                    noise_schedule = None,
                    **kwargs):
    logger.debug("=============== RUN BACKWARD ==============")
    validate_args(model = model, perturb_size = perturb_size)

    logger.info(f"Building model: {model}")
    sde_class = globals().get(model)
    sde = sde_class(N, T, noise_schedule = noise_schedule, perturb_size = perturb_size, **kwargs)

    logger.info(f"Sampling in reverse...")
    reverse_trajectory = sde.sample_reverse_trajectory(n_samples, n_noise_realizations)

    if calculate_lyap:
        logger.info(f"Calculating Lyapunov exponents")
        lexps, lvects = sde.generate_lyap_spectrum(reverse_trajectory)
    else:
        logger.info("Skipping calculation of Lyapunov Spectrum")
        lexps, lvects = None, None

    return reverse_trajectory, lexps, lvects
