import abc
from torch.utils.data import Dataset
import os

DATASETS = []
DATA_DIR = os.path.dirname(__file__)

class DataRegistryMeta(type):
    def __new__(cls, name, bases, class_dict):
        new_class = super().__new__(cls, name, bases, class_dict)
        if name != "DiffusionDataset":
            DATASETS.append(name)
        return new_class
    
class DiffusionDataset(Dataset, metaclass = DataRegistryMeta):
    """Mostly exists to record all the datasets I have access to"""
    def __init__(self):
        super().__init__()