# Efficient Sampling for Doubly Stochastic Variational Inference in Deep Gaussian Processes Regression

This anonymous library is for the reproduce and review of "Efficient Sampling for Doubly Stochastic Variational Inference in Deep Gaussian Processes Regression."

To start the experiment, first create a virtual Python environment with Python=3.10, and then install the packages in requirements.

```bash
conda create -n virtual_environment python=3.10
pip install -r requirements.txt
```

That will take a while as we need to download cuda version of Pytorch. Note that cuda version in requirements.txt is 12.4, the reviewer can choose other version that is compatible with the GPU driver.

In `demo.py`, change the `name` to be `'dsdgp'` or `'edgp'` and then type the following in terminal,
```
python demo.py
```

Note that the __duration__ is likely to change due to different compute resources. 
A too powerful CPU and GPU may moderate the efficiency difference between DSDGP and EDGP. 
To restore the __duration__ results, we suggest running the code in the same computer setting as we did in the paper, i.e., a NVIDIA RTX 3060 GPU with AMD R7 5800H CPU.

# The Difference Between DSDGP and EDGP

Although the paper's rigorous proof appears complex, its implementation is straightforward. The key distinction between DSDGP and EDGP lies in their `layers.py` implementations:
- DSDGP executes `self.conditional_SND(X, full_cov=full_cov)` in every layer.
- EDGP performs this operation only once at the **final layer** and replaces others with a sampling approach (fewer than 20 lines of code) as proposed in **Proposition 1** of the paper.

# Conclusion

In summary, EDGP represents a fully exact deep Gaussian process approach, demonstrating robust performance without compromising on accuracy. 
Through minimal code adjustments, specifically a few lines of modification in `forward` and `__init__`, it significantly reduces computational overhead while enhancing practical performance. 
