# Dual-Forecaster

This repository contains the official implementation for the paper Dual-Forecaster: A Multimodal Time Series Model Integrating Descriptive and Predictive Texts.

![image](figs/Dual-Forecaster.png)

## Requirements

The recommended requirements for Dual-Forecaster are specified as follows:
* Python 3.9.13
* torch==2.2.2
* einops==0.8.0
* pytorch-lightning==2.2.4
* transformers==4.31.0
* huggingface-hub==0.24.6
* datasets==2.19.1
* ruamel_yaml==0.18.6

The dependencies can be installed by:
```bash
pip install -r requirements.txt
```

## Usage

You should firstly download RoBERTa model from huggingface (https://huggingface.co/FacebookAI/roberta-base/tree/main), including 4 files:

* pytorch_model.bin
* vocab.json
* merges.txt
* config.json

And then save them in the /models/roberta_base/.

To train and evaluate Dual-Forecaster on a dataset, run the following command:

```train & evaluate
python train.py --dataset_name <dataset_name> 
```
where `<dataset_name>` is one of `synthetic`, `ETTm1`, `ETTm2`, `ETTh1` and `ETTh2`.


## Baseline

In this paper, the codes of following models have already been included in this repo.

- **DLinear** - Are transformers effective for time series forecasting?[[AAAI 2023]](https://ojs.aaai.org/index.php/AAAI/article/view/26317)[[code]](https://github.com/cure-lab/LTSF-Linear)
- **FITS** - FITS: Modeling Time Series with 10k Parameters[[arXiv 2023]](https://arxiv.org/pdf/2307.03756)[[code]](https://github.com/VEWOXIC/FITS)
- **PatchTST** - A Time Series is Worth 64 Words: Long-term Forecasting with Transformers[[ICLR 2023]](https://arxiv.org/pdf/2211.14730)[[code]](https://github.com/PatchTST/PatchTST)
- **iTransformer** - iTransformer: Inverted Transformers Are Effective for Time Series Forecasting[[ICLR 2024]](https://arxiv.org/pdf/2310.06625)[[code]](https://github.com/thuml/iTransformer)
- **MM-TSFlib** - Time-MMD: A New Multi-Domain Multimodal Dataset for Time Series Analysis[[arXiv 2024]](https://arxiv.org/pdf/2406.08627)[[code]](https://github.com/AdityaLab/MM-TSFlib)
- **Time-LLM** - Time-LLM: Time Series Forecasting by Reprogramming Large Language Models[[ICLR 2024]](https://openreview.net/pdf?id=Unb5CVPtae)[[code]](https://github.com/KimMeen/Time-LLM)


To test baselines on all datasets, run the following command:

```
bash scripts/<dataset>/exp_baseline.sh
```
where `<dataset>` is one of `synthetic` and `captioned_public`.

Note: for testing the baselines of MM-TSFlib and Time-LLM, you should firstly download gpt-2 from huggingface (https://huggingface.co/openai-community/gpt2/tree/main), including 4 files:

* pytorch_model.bin
* vocab.json
* merges.txt
* config.json

And then save them in the /models/gpt2/.