from pybulletgym.envs.mujoco.envs.locomotion.walker_base_env import WalkerBaseMuJoCoEnv
from pybulletgym.envs.mujoco.robots.locomotors.ant import Ant, CustomAnt


class AntMuJoCoEnv(WalkerBaseMuJoCoEnv):
    def __init__(self, target_y=0.0):
        self.robot = Ant(target_y=target_y)
        WalkerBaseMuJoCoEnv.__init__(self, self.robot)

class CustomAntMuJoCoEnv(WalkerBaseMuJoCoEnv):
    def __init__(self, xml_file, target_y=0):
        self.robot = CustomAnt(xml_file, target_y=target_y)
        WalkerBaseMuJoCoEnv.__init__(self, self.robot)
