from pybulletgym.envs.roboschool.envs.locomotion.walker_base_env import WalkerBaseBulletEnv
from pybulletgym.envs.roboschool.robots.locomotors import Humanoid, CustomHumanoid


class HumanoidBulletEnv(WalkerBaseBulletEnv):
    def __init__(self, robot=Humanoid()):
        self.robot = robot
        WalkerBaseBulletEnv.__init__(self, self.robot)
        self.electricity_cost = 4.25 * WalkerBaseBulletEnv.electricity_cost
        self.stall_torque_cost = 4.25 * WalkerBaseBulletEnv.stall_torque_cost

class CustomHumanoidBulletEnv(WalkerBaseBulletEnv):
    def __init__(self, xml_file):
        self.robot = CustomHumanoid(xml_file)
        WalkerBaseBulletEnv.__init__(self, self.robot)
        self.electricity_cost = 4.25 * WalkerBaseBulletEnv.electricity_cost
        self.stall_torque_cost = 4.25 * WalkerBaseBulletEnv.stall_torque_cost
