# ROOT: Rethinking Offline Optimization as Distributional Translation via Probabilistic Bridge
***

## Requirements
```commandline
conda env create -f environment.yml
conda activate ROOT
pip install -r requirements.txt

# install pytorch
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch

# Mujoco Installation
wget https://www.roboti.us/download/mujoco200_linux.zip -O mujoco200_linux.zip
mkdir -p ~/.mujoco
unzip mujoco200_linux.zip -d ~/.mujoco
mv ~/.mujoco/mujoco200_linux ~/.mujoco/mujoco200
rm mujoco200_linux.zip

wget https://www.roboti.us/file/mjkey.txt -O ~/.mujoco/mjkey.txt

export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:~/.mujoco/mujoco200/bin
# follow https://github.com/openai/mujoco-py/issues/627
conda install -c conda-forge glew
conda install -c conda-forge mesalib
conda install -c menpo glfw3
export CPATH=$CONDA_PREFIX/include
python3 -m pip install patchelf
python3 -m pip install Cython==0.29.36 numpy==1.21.5 mujoco_py==2.0.2.3
#
# ./lib/x86_64-linux-gnu/libGL.so.1
# cd envs/lib then ln -s libOSMesa32.so libOSMesa.so
# solve libGL the same as in the above link

# Design-Bench Installation
python3 -m pip install design-bench==2.0.12
python3 -m pip install robel==0.1.2 morphing_agents==1.5.1 transforms3d --no-dependencies
python3 -m pip install botorch==0.6.4 gpytorch==1.6.0
python3 -m pip install gym==0.12.5

# Download Design-Bench Offline Datasets: 
python3 -m pip install gdown
python3 -m pip uninstall charset-normalizer
python3 -m pip install charset-normalizer
python3 -m pip install tensorflow==2.11.0
python3 -m pip install wandb
python3 -m pip install numpy==1.22.4
python3 -m pip install omegaconf
python3 -m pip install einops

```
####
To reproduce our results, run the following command : 
bash scripts/bash.sh

## Acknowledgement
Our code is implemented based on Brownian Bridge Diffusion Models 

[Brownian Bridge Diffusion Models](https://github.com/xuekt98/BBDM)  

## Citation
