#!/bin/bash

models=("dolph2vec" "aves_core" "biolingual")
datasets=("dolphin_reef_balanced")
outfolder="embeddings"
target_sample_rate=44100
seed=42

mkdir -p $outfolder

for model in "${models[@]}"; do
  for dataset in "${datasets[@]}"; do
    echo "Extracting embeddings: model=$model dataset=$dataset"
    python extract_embeddings.py \
      --model "$model" \
      --dataset_name "$dataset" \
      --outfolder "$outfolder" \
      --target_sample_rate "$target_sample_rate" \
      --seed "$seed"
    echo "===================================================="
  done
done
