#!/bin/bash

models=("dolph2vec" "aves_core" "aves_bio" "biolingual" "mfcc" "spectrogram" "spectral_features")

inverse_regs=(0.1 1.0 10.0)

datasets=("detection" "dolphin_reef_unbalanced" "binary_detection")

for model in "${models[@]}"; do
  for dataset in "${datasets[@]}"; do
    for reg in "${inverse_regs[@]}"; do
      echo "Running model: $model with inverse_reg: $reg on dataset $dataset"
      python train_lr_kfold.py --model "$model" --inverse_reg "$reg" --dataset_name "$dataset"
      echo "===================================================="
    done
  done
done
