# Read cfg_path as argument
cfg_path=$1
distilled=$2
n_prompts=$3
dataset=$4
spoofed_only=$5

echo "Running reprompting pipeline with the following parameters:"
echo "cfg_path: $cfg_path"
echo "distilled: $distilled"
echo "n_prompts: $n_prompts"
echo "dataset: $dataset"
echo "spoofed_only: $spoofed_only"

python generate_text.py --cfg_path $cfg_path --distilled $distilled --n_prompts $n_prompts --dataset $dataset --spoofed_only $spoofed_only
python reprompting_method.py --cfg_path $cfg_path --distilled $distilled --n_samples $n_prompts --dataset $dataset --spoofed_only $spoofed_only
python reprompting_preprocess.py --cfg_path $cfg_path --dataset $dataset --spoofed_only $spoofed_only
python preprocess_analysis.py --cfg_path $cfg_path --dataset $dataset --spoofed_only $spoofed_only

echo "Reprompting pipeline completed successfully!"
echo "Parameters used:"
echo "cfg_path: $cfg_path"
echo "distilled: $distilled"
echo "n_prompts: $n_prompts"
echo "dataset: $dataset"
echo "spoofed_only: $spoofed_only"c