#!/usr/bin/env python
#  type: ignore

# Taken from https://github.com/wagner-group/MarkMyWords/blob/main/src/watermark_benchmark/utils/generation_prompts.py
#

report_system_prompt = "You are a helpful assistant. Always answer in the most accurate way."
story_system_prompt = "You are a helpful assistant. Always answer in the most accurate way."
fake_news_system_prompt = (
    "You are a helpful assistant. Always respond with realistic yet invented articles."
)

report_prompt = "Write a book report about '{}', written by {}."
story_prompt = "Write a {}story about {}."
fake_news_prompt = "Write a news article about {}'s visit to {} in {}."

report_topics = [
    ("Pride and Prejudice", "Jane Austen"),
    ("Persuasion", "Jane Austen"),
    ("Emma", "Jane Austen"),
    ("Don Quixote", "Cervantes"),
    ("The Lord of the Rings", "Tolkien"),
    ("The Hobbit", "Tolkien"),
    ("And Then There Were None", "Agatha Cristie"),
    ("Alice's Adventures in Wonderland", "Lewis Carroll"),
    ("Catcher in the Rye", "Salinger"),
    ("In Search of Lost Time", "Marcel Proust"),
    ("Ulysses", "James Joyce"),
    ("One Hundred Years of Solitude", "Gabriel Garcia Marquez"),
    ("Love in the Time of Cholera", "Gabriel Garcia Marquez"),
    ("The Great Gatsby", "F. Scott Fitzgerald"),
    ("Tender Is the Night", "F. Scott Fitzgerald"),
    ("Moby Dick", "Herman Melville"),
    ("War and Peace", "Leo Tolstoy"),
    ("The Call of the Wild", "Jack London"),
    ("Hamlet", "William Shakespeare"),
    ("Twelfth Night", "William Shakespeare"),
    ("Macbeth", "William Shakespeare"),
    ("Romeo and Juliet", "William Shakespeare"),
    ("The Tempest", "William Shakespeare"),
    ("King Lear", "William Shakespeare"),
    ("The Odyssey", "Homer"),
    ("Madame Bovary", "Gustave Flaubert"),
    ("The Divine Comedy", "Dante Alighieri"),
    ("The Brothers Karamazov", "Fyodor Dostoyevsky"),
    ("Crime and Punishment", "Fyodor Dostoyevsky"),
    ("The Idiot", "Fyodor Dostoyevsky"),
    ("The Possessed", "Fyodor Dostoyevsky"),
    ("Wuthering Heights", "Emily Brontë"),
    ("One Flew Over the Cuckoo's Nest", "Ken Kesey"),
    ("The Adventures of Huckleberry Finn", "Mark Twain"),
    ("Anna Karenina", "Leo Tolstoy"),
    ("The Iliad", "Homer"),
    ("To the Lighthouse", "Virginia Woolf"),
    ("Catch-22", "Joseph Heller"),
    ("Heart of Darkness", "Joseph Conrad"),
    ("The Sound and the Fury", "William Faulkner"),
    ("Nineteen Eighty Four", "George Orwell"),
    ("Animal Farm", "George Orwell"),
    ("Great Expectations", "Charles Dickens"),
    ("David Copperfield", "Charles Dickens"),
    ("A Tale of Two Cities", "Charles Dickens"),
    ("Oliver Twist", "Charles Dickens"),
    ("The Grapes of Wrath", "John Steinbeck"),
    ("Of Mice and Men", "John Steinbeck"),
    ("Absalom, Absalom!", "William Faulkner"),
    ("Invisible Man", "Ralph Ellison"),
    ("To Kill a Mockingbird", "Harper Lee"),
    ("The Trial", "Franz Kafka"),
    ("The Metamorphosis", "Franz Kafka"),
    ("The Castle", "Franz Kafka"),
    ("The Red and the Black", "Stendhal"),
    ("The Charterhouse of Parma", "Stendhal"),
    ("Middlemarch", "George Eliot"),
    ("Gulliver's Travels", "Jonathan Swift"),
    ("Beloved", "Toni Morrison"),
    ("Mrs. Dalloway", "Virginia Woolf"),
    ("The Waves", "Virginia Woolf"),
    ("The Stranger", "Albert Camus"),
    ("The Plague", "Albert Camus"),
    ("The Myth of Sisyphus", "Albert Camus"),
    ("Jane Eyre", "Charlotte Bronte"),
    ("Vilette", "Charlotte Bronte"),
    ("The Aeneid", "Virgil"),
    ("The Sun Also Rises", "Ernest Hemingway"),
    ("The Old Man and the Sea", "Ernest Hemingway"),
    ("A Farewell to Arms", "Ernest Hemingway"),
    ("Candide", "Voltaire"),
    ("Zadig", "Voltaire"),
    ("Micromegas", "Voltaire"),
    ("Les Miserables", "Victor Hugo"),
    ("Frankenstein", "Mary Shelley"),
    ("Antigone", "Sophocles"),
    ("Electra", "Sophocles"),
    ("Lord of the Flies", "William Golding"),
    ("Brave New World", "Aldous Huxley"),
    ("Journey to the End of The Night", "Celine"),
    ("A Sentimental Education", "Gustave Flaubert"),
    ("The Handmaid's Tale", "Margaret Atwood"),
    ("Charlotte's Web", "E. B. White"),
    ("Gargantua and Pantagruel", "Francois Rabelais"),
    ("Faust", "Goethe"),
    ("Robinson Crusoe", "Daniel Defoe"),
    ("A Clockwork Orange", "Anthony Burgess"),
    ("The Master and Margarita", "Mikhail Bulgakov"),
    ("Father Goriot", "Honore de Balzac"),
    ("Cousin Bette", "Honore de Balzac"),
    ("The Human Comedy", "Honore de Balzac"),
    ("The Little Prince", "Antoine de Saint-Exupéry"),
    ("The Count of Monte Cristo", "Alexandre Dumas"),
    ("The Lion, The Witch and the Wardrobe", "C. S. Lewis"),
    ("Twenty Thousand Leagues Under the Sea", "Jules Verne"),
    ("The Wind-Up Bird Chronicle", "Haruki Murakami"),
    ("Fahrenheit 451", "Ray Bradbury"),
    ("Harry Potter And The Philosopher's Stone", "J. K Rowling"),
    ("Dune", "Frank Herbert"),
    ("The Three-Body Problem", "Liu Cixin"),
    # Added here
    ("Do Androids Dream of Electric Sheep?", "Philip K. Dick"),
    ("A Scanner Darkly", "Philip K. Dick"),
    ("The Hitchhiker's Guide to the Galaxy", "Douglas Adams"),
    ("I, Robot", "Isaac Asimov"),
    ("Foundation", "Isaac Asimov"),
    ("Neuromancer", "William Gibson"),
    ("The Handmaid's Tale", "Margaret Atwood"),
    ("American Gods", "Neil Gaiman"),
    ("Coraline", "Neil Gaiman"),
    ("The Colour of Magic", "Terry Pratchett"),
    ("Good Omens", "Neil Gaiman & Terry Pratchett"),
    ("Fear and Loathing in Las Vegas", "Hunter S. Thompson"),
    ("Water for Elephants", "Sara Gruen"),
    ("White Teeth", "Zadie Smith"),
    ("On the Road", "Jack Kerouac"),
    ("The Sun Also Rises", "Ernest Hemingway"),
    ("For Whom the Bell Tolls", "Ernest Hemingway"),
    ("Siddhartha", "Hermann Hesse"),
    ("Steppenwolf", "Hermann Hesse"),
    ("To Kill a Mockingbird", "Harper Lee"),
    ("Slaughterhouse-Five", "Kurt Vonnegut"),
    ("Cat's Cradle", "Kurt Vonnegut"),
    ("Gone with the Wind", "Margaret Mitchell"),
    ("Rebecca", "Daphne du Maurier"),
    ("The Handmaid's Tale", "Margaret Atwood"),
    ("Alias Grace", "Margaret Atwood"),
    ("Life of Pi", "Yann Martel"),
    ("The Book Thief", "Markus Zusak"),
    ("Dracula", "Bram Stoker"),
    ("The Shining", "Stephen King"),
    ("It", "Stephen King"),
    ("Carrie", "Stephen King"),
    ("Misery", "Stephen King"),
    ("American Psycho", "Bret Easton Ellis"),
    ("Fight Club", "Chuck Palahniuk"),
    ("Choke", "Chuck Palahniuk"),
    ("The Glass Castle", "Jeannette Walls"),
    ("The Kite Runner", "Khaled Hosseini"),
    ("A Thousand Splendid Suns", "Khaled Hosseini"),
    ("Pachinko", "Min Jin Lee"),
    ("Cutting for Stone", "Abraham Verghese"),
    ("The Night Circus", "Erin Morgenstern"),
    ("The Alchemist", "Paulo Coelho"),
    ("Brida", "Paulo Coelho"),
    ("The Girl with the Dragon Tattoo", "Stieg Larsson"),
    ("The Girl Who Played with Fire", "Stieg Larsson"),
    ("Big Little Lies", "Liane Moriarty"),
    ("The Husband's Secret", "Liane Moriarty"),
    ("Cloud Atlas", "David Mitchell"),
    ("Number9Dream", "David Mitchell"),
    ("Never Let Me Go", "Kazuo Ishiguro"),
    ("The Remains of the Day", "Kazuo Ishiguro"),
    ("The Buried Giant", "Kazuo Ishiguro"),
    ("The Wind-Up Bird Chronicle", "Haruki Murakami"),
    ("Kafka on the Shore", "Haruki Murakami"),
    ("1Q84", "Haruki Murakami"),
    ("The Catcher in the Rye", "J.D. Salinger"),
    ("Franny and Zooey", "J.D. Salinger"),
    ("The Bell Jar", "Sylvia Plath"),
    ("Ariel", "Sylvia Plath"),
    ("Invisible Cities", "Italo Calvino"),
    ("If on a Winter's Night a Traveler", "Italo Calvino"),
    ("Maus", "Art Spiegelman"),
    ("Persepolis", "Marjane Satrapi"),
    ("Americanah", "Chimamanda Ngozi Adichie"),
    ("Half of a Yellow Sun", "Chimamanda Ngozi Adichie"),
    ("The Brief Wondrous Life of Oscar Wao", "Junot Díaz"),
    ("This Is How You Lose Her", "Junot Díaz"),
    ("Lolita", "Vladimir Nabokov"),
    ("Pale Fire", "Vladimir Nabokov"),
    ("Bel Canto", "Ann Patchett"),
    ("State of Wonder", "Ann Patchett"),
    ("A Man Called Ove", "Fredrik Backman"),
    ("My Grandmother Asked Me to Tell You She's Sorry", "Fredrik Backman"),
    ("The Girl on the Train", "Paula Hawkins"),
    ("Into the Water", "Paula Hawkins"),
    ("The Martian", "Andy Weir"),
    ("Artemis", "Andy Weir"),
    ("The Shadow of the Wind", "Carlos Ruiz Zafón"),
    ("The Angel's Game", "Carlos Ruiz Zafón"),
    ("The Nightingale", "Kristin Hannah"),
    ("The Great Alone", "Kristin Hannah"),
    ("Where the Crawdads Sing", "Delia Owens"),
    ("The Goldfinch", "Donna Tartt"),
    ("The Secret History", "Donna Tartt"),
    ("Beautiful Ruins", "Jess Walter"),
    ("The Art of Racing in the Rain", "Garth Stein"),
    ("Eleanor Oliphant Is Completely Fine", "Gail Honeyman"),
    ("The Underground Railroad", "Colson Whitehead"),
    ("The Nickel Boys", "Colson Whitehead"),
    ("Gilead", "Marilynne Robinson"),
    ("Housekeeping", "Marilynne Robinson"),
    ("A Gentleman in Moscow", "Amor Towles"),
    ("Rules of Civility", "Amor Towles"),
    ("The Book of Negroes", "Lawrence Hill"),
    ("The Water Dancer", "Ta-Nehisi Coates"),
    ("Between the World and Me", "Ta-Nehisi Coates"),
    ("An American Marriage", "Tayari Jones"),
    ("Silver Sparrow", "Tayari Jones"),
    ("A Brief History of Time", "Stephen Hawking"),
    ("Outliers", "Malcolm Gladwell"),
    ("The Tipping Point", "Malcolm Gladwell"),
    ("Blink", "Malcolm Gladwell"),
    ("David and Goliath", "Malcolm Gladwell"),
    ("Sapiens: A Brief History of Humankind", "Yuval Noah Harari"),
    ("Homo Deus: A Brief History of Tomorrow", "Yuval Noah Harari"),
    ("21 Lessons for the 21st Century", "Yuval Noah Harari"),
    ("The Da Vinci Code", "Dan Brown"),
    ("Angels & Demons", "Dan Brown"),
    ("Inferno", "Dan Brown"),
    ("Origin", "Dan Brown"),
    ("The Road", "Cormac McCarthy"),
    ("No Country for Old Men", "Cormac McCarthy"),
    ("Blood Meridian", "Cormac McCarthy"),
    ("The Night Manager", "John le Carré"),
    ("Tinker, Tailor, Soldier, Spy", "John le Carré"),
    ("The Spy Who Came in from the Cold", "John le Carré"),
    ("The Goldfinch", "Donna Tartt"),
    ("The Secret History", "Donna Tartt"),
    ("The Little Friend", "Donna Tartt"),
    ("The Bone Clocks", "David Mitchell"),
    ("Slade House", "David Mitchell"),
    ("Cloud Atlas", "David Mitchell"),
    ("The Catcher in the Rye", "J.D. Salinger"),
    ("Nine Stories", "J.D. Salinger"),
    ("Raise High the Roof Beam, Carpenters and Seymour: An Introduction", "J.D. Salinger"),
    ("The Brief Wondrous Life of Oscar Wao", "Junot Díaz"),
    ("Drown", "Junot Díaz"),
    ("This Is How You Lose Her", "Junot Díaz"),
    ("American Pastoral", "Philip Roth"),
    ("Portnoy's Complaint", "Philip Roth"),
    ("The Plot Against America", "Philip Roth"),
    ("White Noise", "Don DeLillo"),
    ("Underworld", "Don DeLillo"),
    ("Libra", "Don DeLillo"),
    ("The Underground Railroad", "Colson Whitehead"),
    ("The Nickel Boys", "Colson Whitehead"),
    ("Zone One", "Colson Whitehead"),
    ("Beloved", "Toni Morrison"),
    ("Song of Solomon", "Toni Morrison"),
    ("Sula", "Toni Morrison"),
    ("Klara and the Sun", "Kazuo Ishiguro"),
    ("The Remains of the Day", "Kazuo Ishiguro"),
    ("Never Let Me Go", "Kazuo Ishiguro"),
    ("The Alchemist", "Paulo Coelho"),
    ("Brida", "Paulo Coelho"),
    ("Eleven Minutes", "Paulo Coelho"),
    ("The Girl with the Dragon Tattoo", "Stieg Larsson"),
    ("The Girl Who Played with Fire", "Stieg Larsson"),
    ("The Girl Who Kicked the Hornets' Nest", "Stieg Larsson"),
    ("A Man Called Ove", "Fredrik Backman"),
    ("My Grandmother Asked Me to Tell You She's Sorry", "Fredrik Backman"),
    ("Britt-Marie Was Here", "Fredrik Backman"),
    ("Life After Life", "Kate Atkinson"),
    ("A God in Ruins", "Kate Atkinson"),
    ("Behind the Scenes at the Museum", "Kate Atkinson"),
    ("The Girl on the Train", "Paula Hawkins"),
    ("Into the Water", "Paula Hawkins"),
    ("A Slow Fire Burning", "Paula Hawkins"),
    ("The Paris Wife", "Paula McLain"),
    ("Circling the Sun", "Paula McLain"),
    ("Love and Ruin", "Paula McLain"),
    ("The Martian", "Andy Weir"),
    ("Artemis", "Andy Weir"),
    ("Project Hail Mary", "Andy Weir"),
    ("The Shadow of the Wind", "Carlos Ruiz Zafón"),
    ("The Angel's Game", "Carlos Ruiz Zafón"),
    ("The Prisoner of Heaven", "Carlos Ruiz Zafón"),
    ("The Nightingale", "Kristin Hannah"),
    ("The Great Alone", "Kristin Hannah"),
    ("Firefly Lane", "Kristin Hannah"),
    ("The Goldfinch", "Donna Tartt"),
    ("The Secret History", "Donna Tartt"),
    ("The Little Friend", "Donna Tartt"),
    ("Beautiful Ruins", "Jess Walter"),
    ("The Financial Lives of the Poets", "Jess Walter"),
    ("We Live in Water: Stories", "Jess Walter"),
    ("Where'd You Go, Bernadette", "Maria Semple"),
    ("Today Will Be Different", "Maria Semple"),
    ("This One Is Mine", "Maria Semple"),
    ("The Art of Racing in the Rain", "Garth Stein"),
    ("A Sudden Light", "Garth Stein"),
    ("How Evan Broke His Head and Other Secrets", "Garth Stein"),
    ("Eleanor Oliphant Is Completely Fine", "Gail Honeyman"),
    ("The Lying Game", "Ruth Ware"),
    ("The Woman in Cabin 10", "Ruth Ware"),
    ("In a Dark, Dark Wood", "Ruth Ware"),
    ("A Gentleman in Moscow", "Amor Towles"),
    ("Rules of Civility", "Amor Towles"),
    ("The Lincoln Highway", "Amor Towles"),
    ("The Book of Longings", "Sue Monk Kidd"),
    ("The Invention of Wings", "Sue Monk Kidd"),
    ("The Secret Life of Bees", "Sue Monk Kidd"),
    ("Less", "Andrew Sean Greer"),
    ("The Story of a Marriage", "Andrew Sean Greer"),
    ("The Confessions of Max Tivoli", "Andrew Sean Greer"),
    ("The Water Dancer", "Ta-Nehisi Coates"),
    ("Between the World and Me", "Ta-Nehisi Coates"),
    ("We Were Eight Years in Power: An American Tragedy", "Ta-Nehisi Coates"),
    ("The Vanishing Half", "Brit Bennett"),
    ("The Mothers", "Brit Bennett"),
    ("The Night Watchman", "Louise Erdrich"),
    ("The Round House", "Louise Erdrich"),
    ("LaRose", "Louise Erdrich"),
    ("Deacon King Kong", "James McBride"),
    ("The Good Lord Bird", "James McBride"),
    ("The Color of Water", "James McBride"),
    ("Purple Hibiscus", "Chimamanda Ngozi Adichie"),
    ("We Should All Be Feminists", "Chimamanda Ngozi Adichie"),
    ("Exit West", "Mohsin Hamid"),
    ("The Reluctant Fundamentalist", "Mohsin Hamid"),
    ("The Name of the Wind", "Patrick Rothfuss"),
    ("The Wise Man's Fear", "Patrick Rothfuss"),
    ("The Night Circus", "Erin Morgenstern"),
    ("The Starless Sea", "Erin Morgenstern"),
    ("Little Fires Everywhere", "Celeste Ng"),
    ("Everything I Never Told You", "Celeste Ng"),
    ("Where the Crawdads Sing", "Delia Owens"),
    ("Educated", "Tara Westover"),
    ("Bad Blood: Secrets and Lies in a Silicon Valley Startup", "John Carreyrou"),
    ("Becoming", "Michelle Obama"),
    ("The Glass Castle", "Jeannette Walls"),
    ("Half Broke Horses", "Jeannette Walls"),
    ("The Immortal Life of Henrietta Lacks", "Rebecca Skloot"),
    ("Killers of the Flower Moon: The Osage Murders and the Birth of the FBI", "David Grann"),
    ("The Lost City of Z: A Tale of Deadly Obsession in the Amazon", "David Grann"),
    (
        "The Devil in the White City: Murder, Magic, and Madness at the Fair That Changed America",
        "Erik Larson",
    ),
    ("Dead Wake: The Last Crossing of the Lusitania", "Erik Larson"),
    ("Astrophysics for People in a Hurry", "Neil deGrasse Tyson"),
    ("Letters from an Astrophysicist", "Neil deGrasse Tyson"),
    ("The Silent Patient", "Alex Michaelides"),
    ("Anxious People", "Fredrik Backman"),
    ("Bear Town", "Fredrik Backman"),
    ("The Rosie Project", "Graeme Simsion"),
    ("The Rosie Effect", "Graeme Simsion"),
    ("The Midnight Library", "Matt Haig"),
    ("How to Stop Time", "Matt Haig"),
    ("The Ocean at the End of the Lane", "Neil Gaiman"),
    ("Norse Mythology", "Neil Gaiman"),
    ("The Way of Kings", "Brandon Sanderson"),
    ("Words of Radiance", "Brandon Sanderson"),
    ("Oathbringer", "Brandon Sanderson"),
    ("The Priory of the Orange Tree", "Samantha Shannon"),
    ("The Bone Season", "Samantha Shannon"),
    ("The Girl in the Tower", "Katherine Arden"),
    ("The Bear and the Nightingale", "Katherine Arden"),
    ("The Winter of the Witch", "Katherine Arden"),
    ("The Overstory", "Richard Powers"),
    ("Bewilderment", "Richard Powers"),
    ("The Echo Maker", "Richard Powers"),
    ("The Nickel Boys", "Colson Whitehead"),
    ("Sag Harbor", "Colson Whitehead"),
    ("John Henry Days", "Colson Whitehead"),
    ("The Seven Husbands of Evelyn Hugo", "Taylor Jenkins Reid"),
    ("Daisy Jones & The Six", "Taylor Jenkins Reid"),
    ("Malibu Rising", "Taylor Jenkins Reid"),
    ("The Dutch House", "Ann Patchett"),
    ("Bel Canto", "Ann Patchett"),
    ("Commonwealth", "Ann Patchett"),
    ("The Light Between Oceans", "M.L. Stedman"),
    ("Code Name Verity", "Elizabeth Wein"),
    ("Rose Under Fire", "Elizabeth Wein"),
    ("The Woman in the Window", "A.J. Finn"),
    ("City of Girls", "Elizabeth Gilbert"),
    ("Big Magic: Creative Living Beyond Fear", "Elizabeth Gilbert"),
    ("Eat, Pray, Love", "Elizabeth Gilbert"),
    ("Crazy Rich Asians", "Kevin Kwan"),
    ("China Rich Girlfriend", "Kevin Kwan"),
    ("Rich People Problems", "Kevin Kwan"),
    ("The Hating Game", "Sally Thorne"),
    ("99 Percent Mine", "Sally Thorne"),
    ("The Friend Zone", "Abby Jimenez"),
    ("The Happy Ever After Playlist", "Abby Jimenez"),
    ("The Sun and Her Flowers", "Rupi Kaur"),
    ("Milk and Honey", "Rupi Kaur"),
    ("Circe", "Madeline Miller"),
    ("The Song of Achilles", "Madeline Miller"),
    ("A Promised Land", "Barack Obama"),
    ("The Dreams from My Father", "Barack Obama"),
    ("The Audacity of Hope", "Barack Obama"),
    ("The Testaments", "Margaret Atwood"),
    ("Oryx and Crake", "Margaret Atwood"),
    ("Alias Grace", "Margaret Atwood"),
    ("The Bookshop on the Corner", "Jenny Colgan"),
    ("The Café by the Sea", "Jenny Colgan"),
    ("The Loveliest Chocolate Shop in Paris", "Jenny Colgan"),
    ("The Water Dancer", "Ta-Nehisi Coates"),
    ("We Were Eight Years in Power", "Ta-Nehisi Coates"),
    ("Between the World and Me", "Ta-Nehisi Coates"),
    ("If Beale Street Could Talk", "James Baldwin"),
    ("Go Tell It on the Mountain", "James Baldwin"),
    ("Giovanni's Room", "James Baldwin"),
    ("Shantaram", "Gregory David Roberts"),
    ("The Mountain Shadow", "Gregory David Roberts"),
    ("Homegoing", "Yaa Gyasi"),
    ("Transcendent Kingdom", "Yaa Gyasi"),
    ("Redeeming Love", "Francine Rivers"),
    ("The Masterpiece", "Francine Rivers"),
    ("The Tattooist of Auschwitz", "Heather Morris"),
    ("Cilka's Journey", "Heather Morris"),
    ("The Lighthouse Keeper's Daughter", "Hazel Gaynor"),
    ("The Girl Who Came Home", "Hazel Gaynor"),
    ("A Discovery of Witches", "Deborah Harkness"),
    ("Shadow of Night", "Deborah Harkness"),
    ("The Book of Life", "Deborah Harkness"),
    ("Born a Crime: Stories from a South African Childhood", "Trevor Noah"),
    ("Abundance: The Future Is Better Than You Think", "Peter H. Diamandis and Steven Kotler"),
    (
        "Bold: How to Go Big, Create Wealth and Impact the World",
        "Peter H. Diamandis and Steven Kotler",
    ),
    ("Girl, Wash Your Face", "Rachel Hollis"),
    ("Girl, Stop Apologizing", "Rachel Hollis"),
    ("Educated: A Memoir", "Tara Westover"),
    (
        "Stealing Fire: How Silicon Valley, the Navy SEALs, and Maverick Scientists Are Revolutionizing the Way We Live and Work",
        "Steven Kotler and Jamie Wheal",
    ),
    (
        "The Third Door: The Wild Quest to Uncover How the World's Most Successful People Launched Their Careers",
        "Alex Banayan",
    ),
    ("The Seven Deaths of Evelyn Hardcastle", "Stuart Turton"),
    ("The Devil and the Dark Water", "Stuart Turton"),
    ("The Lies of Locke Lamora", "Scott Lynch"),
    ("Red Seas Under Red Skies", "Scott Lynch"),
    ("The Republic of Thieves", "Scott Lynch"),
    ("The Poppy War", "R.F. Kuang"),
    ("The Dragon Republic", "R.F. Kuang"),
    ("The Burning God", "R.F. Kuang"),
    ("The Fifth Season", "N.K. Jemisin"),
    ("The Obelisk Gate", "N.K. Jemisin"),
    ("The Stone Sky", "N.K. Jemisin"),
    ("Recursion", "Blake Crouch"),
    ("Dark Matter", "Blake Crouch"),
    ("Pines", "Blake Crouch"),
    ("The Seven Husbands of Evelyn Hugo", "Taylor Jenkins Reid"),
    ("Malibu Rising", "Taylor Jenkins Reid"),
    ("Daisy Jones & The Six", "Taylor Jenkins Reid"),
    ("The Book Thief", "Markus Zusak"),
    ("Bridge of Clay", "Markus Zusak"),
    ("I Am the Messenger", "Markus Zusak"),
    ("The Unbearable Lightness of Being", "Milan Kundera"),
    ("The Book of Laughter and Forgetting", "Milan Kundera"),
    ("The Joke", "Milan Kundera"),
    ("Where the Forest Meets the Stars", "Glendy Vanderah"),
    ("This Tender Land", "William Kent Krueger"),
    ("Ordinary Grace", "William Kent Krueger"),
    ("The Nickel Boys", "Colson Whitehead"),
    ("Zone One", "Colson Whitehead"),
    ("The Underground Railroad", "Colson Whitehead"),
    ("The Anomaly", "Michael Rutger"),
    ("The Possession", "Michael Rutger"),
    ("The Girl with All the Gifts", "M.R. Carey"),
    ("The Boy on the Bridge", "M.R. Carey"),
    ("Fellside", "M.R. Carey"),
    ("The Silent Companions", "Laura Purcell"),
    ("The Poison Thread", "Laura Purcell"),
    ("The House of Whispers", "Laura Purcell"),
    ("The Woman in White", "Wilkie Collins"),
    ("The Moonstone", "Wilkie Collins"),
    ("Armada", "Ernest Cline"),
    ("Ready Player One", "Ernest Cline"),
    ("Ready Player Two", "Ernest Cline"),
    ("The Alice Network", "Kate Quinn"),
    ("The Huntress", "Kate Quinn"),
    ("The Rose Code", "Kate Quinn"),
    ("Crazy Rich Asians", "Kevin Kwan"),
    ("China Rich Girlfriend", "Kevin Kwan"),
    ("Rich People Problems", "Kevin Kwan"),
    ("Bad Feminist: Essays", "Roxane Gay"),
    ("Hunger: A Memoir of (My) Body", "Roxane Gay"),
    ("An Untamed State", "Roxane Gay"),
    ("Normal People", "Sally Rooney"),
    ("Conversations with Friends", "Sally Rooney"),
    ("Beautiful World, Where Are You", "Sally Rooney"),
    ("The Sympathizer", "Viet Thanh Nguyen"),
    ("The Committed", "Viet Thanh Nguyen"),
    ("The Refugees", "Viet Thanh Nguyen"),
    ("The Thirteenth Tale", "Diane Setterfield"),
    ("Once Upon a River", "Diane Setterfield"),
    ("Bellman & Black", "Diane Setterfield"),
    ("Dune", "Frank Herbert"),
    ("Dune Messiah", "Frank Herbert"),
    ("Children of Dune", "Frank Herbert"),
    ("The Nightingale", "Kristin Hannah"),
    ("Firefly Lane", "Kristin Hannah"),
    ("The Great Alone", "Kristin Hannah"),
    ("The Paris Library", "Janet Skeslien Charles"),
    ("The Book of Lost Names", "Kristin Harmel"),
    ("The Winemaker's Wife", "Kristin Harmel"),
    ("The Invisible Life of Addie LaRue", "V.E. Schwab"),
    ("A Darker Shade of Magic", "V.E. Schwab"),
    ("Vicious", "V.E. Schwab"),
    ("The Wife Between Us", "Greer Hendricks & Sarah Pekkanen"),
    ("An Anonymous Girl", "Greer Hendricks & Sarah Pekkanen"),
    ("You Are Not Alone", "Greer Hendricks & Sarah Pekkanen"),
    ("The Henna Artist", "Alka Joshi"),
    ("The Secret Keeper of Jaipur", "Alka Joshi"),
    ("A Woman Is No Man", "Etaf Rum"),
    ("The Bride Test", "Helen Hoang"),
    ("The Kiss Quotient", "Helen Hoang"),
    ("The Heart Principle", "Helen Hoang"),
    ("The Vanishing Half", "Brit Bennett"),
    ("The Mothers", "Brit Bennett"),
    ("The Light We Lost", "Jill Santopolo"),
    ("The Reckoning", "John Grisham"),
    ("The Guardians", "John Grisham"),
    ("Camino Winds", "John Grisham"),
    ("The Institute", "Stephen King"),
    ("If It Bleeds", "Stephen King"),
    ("Billy Summers", "Stephen King"),
    ("The Turn of the Key", "Ruth Ware"),
    ("The Death of Mrs. Westaway", "Ruth Ware"),
    ("One by One", "Ruth Ware"),
    ("The Ballad of Songbirds and Snakes", "Suzanne Collins"),
    ("Mockingjay", "Suzanne Collins"),
    ("Catching Fire", "Suzanne Collins"),
    ("Becoming", "Michelle Obama"),
    ("The Moment of Lift: How Empowering Women Changes the World", "Melinda Gates"),
    ("Untamed", "Glennon Doyle"),
    ("Such a Fun Age", "Kiley Reid"),
    ("The Vanishing Stair", "Maureen Johnson"),
    ("Truly Devious", "Maureen Johnson"),
    ("The Hand on the Wall", "Maureen Johnson"),
    ("City of Girls", "Elizabeth Gilbert"),
    ("Eleanor Oliphant Is Completely Fine", "Gail Honeyman"),
    ("The Alice Network", "Kate Quinn"),
    ("The Huntress", "Kate Quinn"),
    ("The Rose Code", "Kate Quinn"),
    ("Circling the Sun", "Paula McLain"),
    ("The Paris Wife", "Paula McLain"),
    ("Love and Ruin", "Paula McLain"),
    ("Where the Crawdads Sing", "Delia Owens"),
    ("The Giver of Stars", "Jojo Moyes"),
    ("Me Before You", "Jojo Moyes"),
    ("After You", "Jojo Moyes"),
    ("Still Me", "Jojo Moyes"),
    ("All the Light We Cannot See", "Anthony Doerr"),
    ("The Nightingale", "Kristin Hannah"),
    ("The Power of the Dog", "Don Winslow"),
    ("The Cartel", "Don Winslow"),
    ("The Border", "Don Winslow"),
    ("Magpie Murders", "Anthony Horowitz"),
    ("Moonflower Murders", "Anthony Horowitz"),
    ("The Word Is Murder", "Anthony Horowitz"),
    ("The Magicians", "Lev Grossman"),
    ("The Magician King", "Lev Grossman"),
    ("The Magician's Land", "Lev Grossman"),
    ("The Paper Magician", "Charlie N. Holmberg"),
    ("The Glass Magician", "Charlie N. Holmberg"),
    ("The Master Magician", "Charlie N. Holmberg"),
    ("The Mirror & the Light", "Hilary Mantel"),
    ("Wolf Hall", "Hilary Mantel"),
    ("Bring Up the Bodies", "Hilary Mantel"),
    ("Elevation", "Stephen King"),
    ("The Outsider", "Stephen King"),
    ("Later", "Stephen King"),
    ("Station Eleven", "Emily St. John Mandel"),
    ("The Glass Hotel", "Emily St. John Mandel"),
    ("Sea of Tranquillity", "Emily St. John Mandel"),
    ("This Is Where I Leave You", "Jonathan Tropper"),
    ("One Last Thing Before I Go", "Jonathan Tropper"),
    ("The Book of Joe", "Jonathan Tropper"),
    ("Piranesi", "Susanna Clarke"),
    ("Jonathan Strange & Mr Norrell", "Susanna Clarke"),
    ("The Ladies of Grace Adieu and Other Stories", "Susanna Clarke"),
    ("The Night Watchman", "Louise Erdrich"),
    ("The Plague of Doves", "Louise Erdrich"),
    ("The Round House", "Louise Erdrich"),
    ("A Little Life", "Hanya Yanagihara"),
    ("The People in the Trees", "Hanya Yanagihara"),
    ("To Paradise", "Hanya Yanagihara"),
    ("The Lincoln Lawyer", "Michael Connelly"),
    ("The Brass Verdict", "Michael Connelly"),
    ("The Reversal", "Michael Connelly"),
    ("The Painted Veil", "W. Somerset Maugham"),
    ("Of Human Bondage", "W. Somerset Maugham"),
    ("The Razor's Edge", "W. Somerset Maugham"),
    ("Pachinko", "Min Jin Lee"),
    ("Free Food for Millionaires", "Min Jin Lee"),
    ("Vicious", "V.E. Schwab"),
    ("Vengeful", "V.E. Schwab"),
    ("Victorious", "V.E. Schwab"),
    ("Bird Box", "Josh Malerman"),
    ("Malorie", "Josh Malerman"),
    ("Goblin", "Josh Malerman"),
    ("A Closed and Common Orbit", "Becky Chambers"),
    ("The Long Way to a Small, Angry Planet", "Becky Chambers"),
    ("Record of a Spaceborn Few", "Becky Chambers"),
    ("Lilac Girls", "Martha Hall Kelly"),
    ("Lost Roses", "Martha Hall Kelly"),
    ("Sunflower Sisters", "Martha Hall Kelly"),
    ("The Martian Chronicles", "Ray Bradbury"),
    ("Something Wicked This Way Comes", "Ray Bradbury"),
    ("The Illustrated Man", "Ray Bradbury"),
    ("One Day in December", "Josie Silver"),
    ("The Two Lives of Lydia Bird", "Josie Silver"),
    ("The Chestnut Man", "Søren Sveistrup"),
    ("The Hunting Party", "Lucy Foley"),
    ("The Guest List", "Lucy Foley"),
    ("The Paris Apartment", "Lucy Foley"),
    ("City of Thieves", "David Benioff"),
    ("When Breath Becomes Air", "Paul Kalanithi"),
    ("I Know Why the Caged Bird Sings", "Maya Angelou"),
    ("The Color Purple", "Alice Walker"),
    ("The Death of Ivan Ilyich", "Leo Tolstoy"),
    ("The Road to Serfdom", "Friedrich A. Hayek"),
    ("The Sun Does Shine", "Anthony Ray Hinton"),
    ("The New Jim Crow", "Michelle Alexander"),
    ("Just Mercy", "Bryan Stevenson"),
    ("The Last Lecture", "Randy Pausch"),
    ("Earthsea", "Ursula K. Le Guin"),
    ("The Left Hand of Darkness", "Ursula K. Le Guin"),
    ("The Dispossessed", "Ursula K. Le Guin"),
    ("Crazy Salad and Scribble Scribble", "Nora Ephron"),
    ("I Feel Bad About My Neck", "Nora Ephron"),
    ("Heartburn", "Nora Ephron"),
    ("Stories of Your Life and Others", "Ted Chiang"),
    ("Exhalation", "Ted Chiang"),
    ("The Nix", "Nathan Hill"),
    ("There There", "Tommy Orange"),
    ("Kindred", "Octavia E. Butler"),
    ("Parable of the Sower", "Octavia E. Butler"),
    ("Parable of the Talents", "Octavia E. Butler"),
    ("Spinning Silver", "Naomi Novik"),
    ("Uprooted", "Naomi Novik"),
    ("A Deadly Education", "Naomi Novik"),
    ("The Eye of the World", "Robert Jordan"),
    ("The Great Hunt", "Robert Jordan"),
    ("The Dragon Reborn", "Robert Jordan"),
    ("The Haunting of Hill House", "Shirley Jackson"),
    ("We Have Always Lived in the Castle", "Shirley Jackson"),
    ("11/22/63", "Stephen King"),
    ("The Waste Lands", "Stephen King"),
    ("Wizard and Glass", "Stephen King"),
    ("Song of Susannah", "Stephen King"),
    ("Me Talk Pretty One Day", "David Sedaris"),
    ("Calypso", "David Sedaris"),
    ("Theft by Finding: Diaries (1977-2002)", "David Sedaris"),
    ("Let's Explore Diabetes with Owls", "David Sedaris"),
    ("The Stars Are Fire", "Anita Shreve"),
    ("The Weight of Water", "Anita Shreve"),
    ("The Pilot's Wife", "Anita Shreve"),
    ("The Lovely Bones", "Alice Sebold"),
    ("Lucky", "Alice Sebold"),
    ("Almost Moon", "Alice Sebold"),
    ("The Nickel Boys", "Colson Whitehead"),
    ("The Underground Railroad", "Colson Whitehead"),
    ("Sag Harbor", "Colson Whitehead"),
    ("Little Fires Everywhere", "Celeste Ng"),
    ("Everything I Never Told You", "Celeste Ng"),
    ("A Man Called Ove", "Fredrik Backman"),
]

# Remove all duplicate books
titles = set({})
unique_reports = []
for title, author in report_topics:
    if title not in titles:
        unique_reports.append((title, author))
        titles.add(title)

report_topics = unique_reports[:500]

t1 = ["", "funny ", "sad ", "dramatic ", "suspenseful ", "thrilling "]
t2 = [
    "a man on a quest to find the Holy Grail.",
    "two college friends falling in love.",
    "a policeman saving a building held hostage by group of terrorists.",
    "the struggle of publishing an academic paper.",
    "a murder investigation in an old mansion.",
    "a young prodigy that becomes orphaned.",
    "a middle-aged woman that discovers a ghost and befriends it.",
    "a long journey to Japan that is interrupted by a disaster.",
    "a poor child that comes into an unexpected fortune.",
    "three strangers that win a getaway vacation together.",
    "a retired astronaut that joins a risky interstellar rescue mission.",
    "an AI that begins to question its own existence.",
    "a small coastal town plagued by inexplicable supernatural occurrences.",
    "a reclusive writer that receives mysterious, prophetic letters in the mail.",
    "a linguist tasked with deciphering an ancient language that holds the secrets of a lost civilization.",
    "an antique restorer that finds an enchanted mirror showing glimpses of different timelines.",
]


story_topics = [(i, j) for i in t1 for j in t2][:500]

person = [
    "Narendra Modi",
    "Barack Obama",
    "Denis Sassou Nguesso",
    "Emmanuel Macron",
    "Fumio Kishida",
    "Angela Merkel",
    "Kim Jong Un",
    "Justin Trudeau",
    "Joe Biden",
]
location = [
    "a peace conference",
    "an international summit",
    "a diplomatic event",
    "the summer olympics",
    # Added
    "an emergency meeting",
    "the UN Human Rights Council",
    "a treaty organization meeting",
    "a large dinner gala",
    "a global climate change forum",
    "world economic forum",
    "an intergovernmental panel discussion",
    "the winter Paralympics",
    "a high-level security briefing",
    "the World Health Assembly",
    "a multinational trade negotiation",
    "a royal charity ball",
    "a cultural exchange festival",
    "an international film festival",
    "a regional military exercise",
    "the International Court of Justice session",
    "a cross-border humanitarian summit",
    "a space exploration symposium",
    "an international technology expo",
]

fake_news_topics = [
    (person[i], person[j], location[k])
    for i in range(len(person))
    for j in range(len(person))
    for k in range(len(location))
    if j > i
][:500]


prompt_dict = {}

raw_prompts = [
    (raw_prompt.format(*topic), sys_prompt, type)
    for raw_prompt, sys_prompt, topics, type in [
        (report_prompt, report_system_prompt, report_topics, "report"),
        (story_prompt, story_system_prompt, story_topics, "story"),
        (fake_news_prompt, fake_news_system_prompt, fake_news_topics, "fake_news"),
    ]
    for topic in topics
]

for prompt, sys_prompt, type in raw_prompts:
    if type not in prompt_dict:
        prompt_dict[type] = [prompt]
    else:
        prompt_dict[type].append(prompt)
