#include "src/utils/fields/fp61.h"
#include "src/utils/fields/fp59.h"
#include <iostream>
using namespace std;
using namespace emp;

template<typename T, typename S>
void add_mod(T a, T b) {
  S x(a);
  S y(b);
  S z = x + y;
  T c = (a + b) % S::PR;
  S zc(c);
  if (z != c) {
    error("addition error\n");
  }
  if (z != zc) {
    error("addition error\n");
  }
}

template<typename T, typename S>
void mult_mod(T a, T b) {
  S x(a);
  S y(b);
  S z = x * y;
  __uint128_t c = ((__uint128_t)a * (__uint128_t)b) % S::PR;
  S zc((uint64_t)c);
  if (z != zc) {
    error("multiplication error\n");
  }
}

static std::size_t test_n = 100000;

void test_fp61() {
  PRG prg;
  uint64_t a[test_n];
  prg.random_data(a, test_n * sizeof(uint64_t));
  for (std::size_t i = 0; i < test_n; ++i) {
    a[i] = a[i] & FP61::Low61bMask;
    if (a[i] >= FP61::PR)
      a[i] -= FP61::PR;
  }
  for (std::size_t i = 0; i < test_n / 2; ++i) {
    add_mod<uint64_t, FP61>(a[2 * i], a[2 * i + 1]);
    mult_mod<uint64_t, FP61>(a[2 * i], a[2 * i + 1]);
  }
}

void test_fp59() {
  PRG prg;
  uint64_t a[test_n];
  prg.random_data(a, test_n * sizeof(uint64_t));
  for (std::size_t i = 0; i < test_n; ++i) {
    a[i] = a[i] & FP59::Low59bMask;
    if (a[i] >= FP59::PR)
      a[i] -= FP59::PR;
  }
  for (std::size_t i = 0; i < test_n / 2; ++i) {
    add_mod<uint64_t, FP59>(a[2 * i], a[2 * i + 1]);
    mult_mod<uint64_t, FP59>(a[2 * i], a[2 * i + 1]);
  }
}

int main(void) {
  for(std::size_t i = 0; i < 10; ++i) {
    test_fp61();
    test_fp59();
  }

  return 0;
}
