#!/bin/bash

k_stdevs_values=(2 3 4 5 6)  # values for k_stdevs
epsilon_values=(1.0 2.0 3.0 5.0 6.0 10.0 )  #values for epsilon
num_bits_values=(12 14 16 18 )  # values for num_bits


base_command="bazel run dp_ftrl:run_stackoverflow_multi -- --aggregator_method=opt_prefix_sum_matrix --total_rounds=2000 --total_epochs=6 --clients_per_round=40 --task=stackoverflow_word --matrix_root_path=/home/ubuntu/dpfl/our_federated/mf_dpftrl_matrices/bands1000_rounds2000"

# Iterate over all combinations of the hyperparameters
for k_stdevs in "${k_stdevs_values[@]}"; do
    for epsilon in "${epsilon_values[@]}"; do
        for num_bits in "${num_bits_values[@]}"; do


            result_dir="/home/ubuntu/dpfl/our_federated/distributed_dp_matrix_factorization/results_new"
            experiment_name="stackoverflow_k${k_stdevs}_eps${epsilon}_bits${num_bits}"



            # additional command with hyperparameters
            command="${base_command} --k_stddevs=${k_stdevs} --epsilon=${epsilon} --num_bits=${num_bits} --root_output_dir=${result_dir} --experiment_name=${experiment_name}"


            echo "Executing command: $command"

            log_file="${result_dir}/output.log"
            # Run the command
            bash -c "$command" > "$log_file" 2>&1

            # Print completion message
            echo "Completed run for k_stdevs=${k_stdevs}, epsilon=${epsilon}, num_bits=${num_bits}"
            echo "Results saved in ${result_dir}"
            echo "---------------------------------------------"
        done
    done
done