#ifndef UTILS_UTILS_H__
#define UTILS_UTILS_H__

const static __uint128_t uint128_select_low = (__uint128_t)0xFFFFFFFFFFFFFFFF;

inline uint64_t uint128_get_high(const __uint128_t x) {
  __uint128_t y = x >> 64;
  return (uint64_t)y;
}

inline uint64_t uint128_get_low(const __uint128_t x) {
  __uint128_t y = x & uint128_select_low;
  return (uint64_t)y;
}

inline uint64_t reverse_bits(uint64_t x, uint64_t bit_width) {
  //HEXL_CHECK(x == 0 || MSB(x) <= bit_width, "MSB(" << x << ") = " << MSB(x)
                                                  //<< " must be >= bit_width "
                                                  //<< bit_width)
  if (bit_width == 0) {
    return 0;
  }
  uint64_t rev = 0;
  for (uint64_t i = bit_width; i > 0; i--) {
    rev |= ((x & 1) << (i - 1));
    x >>= 1;
  }
  return rev;
}

template<typename IO>
inline void flush_io(std::vector<IO**> &ios, std::size_t num) {
  for(std::size_t i = 0; i < ios.size(); ++i) {
    if(ios[i] == nullptr) continue;
    for(std::size_t j = 0; j < num; ++j) {
      ios[i][j]->flush();
    }
  }
}

#endif
