Distributed DP Matrix Factorization Code:

1. Install Required Packages:
Ensure that all necessary dependencies are installed. You can do this by running:
pip install -r requirements.txt

2. Install Jax and Jaxlib:
You'll need to install specific versions of jax and jaxlib (version 0.1.71). Since this version is not available via pip, you'll have to build it from the source. Instructions for building JAX from the source can be found in the official JAX repository: https://github.com/google/jax#building-from-source


3. Generate Matrices for the Honaker Online Method:
To generate matrices using the Honaker online method, use the following command:

bazel run :factorize_prefix_sum -- --strategy=identity --log_2_observations=11 --root_output_dir=/tmp/matrix_factorizations
This will generate matrices with the specified parameters and store them in /tmp/matrix_factorizations.

4. Execute the training for the Honaker Online factorization for the EMNIST Dataset:
Run the code for the EMNIST dataset with the following command:

bazel run dp_ftrl:run_emnist -- --aggregator_method=opt_prefix_sum_matrix --num_bits=18 --total_rounds=512 --total_epochs=22 --clients_per_round=40 --task=emnist_character --matrix_root_path=/home/ubuntu/dpfl/our_federated/distributed_dp_matrix_factorization/final_matrices/matrix_factorizations_tree --epsilon=5 --experiment_name=stackoverflow_eps5 --root_output_dir=/home/ubuntu/dpfl/our_federated/distributed_dp_matrix_factorization/results_final
Explanation:
--aggregator_method=opt_prefix_sum_matrix: Specifies the aggregator method.
--num_bits=18: Specifies the bit precision for cryptographic operations.
--total_rounds=512: Number of federated learning rounds.
--total_epochs=22: Specifies the number of epochs (maximum number of times a client participates, k).
--clients_per_round=40: Number of clients per round.
--task=emnist_character: Specifies the EMNIST character dataset.
--matrix_root_path: Path to the matrix factorization files.
--epsilon=5: Privacy budget.
--experiment_name=stackoverflow_eps5: Name of the experiment.
--root_output_dir: Directory for saving output results.


5. Execute the training for the optimal Multi-Epoch factorization for the EMNIST Dataset:
If you need to run the multi-epoch code, use the following command:

bazel run dp_ftrl:run_emnist -- --aggregator_method=opt_prefix_sum_matrix --num_bits=18 --total_rounds=748 --total_epochs=22 --clients_per_round=40 --task=emnist_character --matrix_root_path=/home/ubuntu/dpfl/our_federated/multi_epoch_dp_matrix_factorization/emnist_multi_765 --epsilon=5 --root_output_dir=/home/ubuntu/dpfl/our_federated/distributed_dp_matrix_factorization/results_final_multi experiment_name=emnist_epsilon5
Explanation:
same as above

