DP Matrix Factorization Multi-Epoch for Matrix Generation
To generate the matrices, first install the required dependencies using:


pip install -r requirements.txt
Next, generate the matrices with the following command:

bazel run multiple_participations:factorize_multi_epoch_prefix_sum -- --num_epochs=22 --steps_per_epoch=34 --steps_per_eval=10 --root_output_dir=/home/ubuntu/dpfl/our_federated/multi_epoch_dp_matrix_factorization --run_name=emnist_multi_748 --max_iterations=3000
num_epochs: Defines the maximum number of times a client can participate.
steps_per_epoch: Defines the interval between consecutive participations of a client.
After generating the matrices, you can train them using the instructions provided in the distributed_dp_matrix_factorization folder.

Manual Adjustments
Due to some dependency issues, manual changes were made to the TensorFlow Federated (TFF) file to ensure compatibility with our code. Specifically, in tff.types, a deprecated method type_from_tensors was added, which is used in the optimization.py file. Below is the added code snippet:

python
Copy code
"""Builds a tff.Type from supplied tensors.

Args:
  tensors: A nested structure of tensors.

Returns:
  The nested TensorType structure.
"""

def _mapping_fn(x):
  if not tf.is_tensor(x):
    x = tf.convert_to_tensor(x)
  return computation_types.TensorType(x.dtype.base_dtype, x.shape)

if isinstance(tensors, structure.Struct):
  type_spec = structure.map_structure(_mapping_fn, tensors)
else:
  type_spec = tf.nest.map_structure(_mapping_fn, tensors)
return computation_types.to_type(type_spec)








