## SmoothInit and Fast-SmoothInit

### 1. Environment

```bash
conda create -n smoothinit python=3.10
conda activate smoothinit
conda install pytorch==2.3.1 torchvision==0.18.1 torchaudio==2.3.1 pytorch-cuda=12.1 -c pytorch -c nvidia
pip install diffusers timm wandb einops pandas
```

### 2. Inference

```bash
python inference.py
```

Please note that the hyperparameters are stored in `inference.py`. Specifically, you can change the following parameters:

### Hyperparameters Description

- `--method`: The name of the base model to use.
  - Type: `str`
  - Default: `animatediffv3`
  - Choices: `["animatediffv3", "animatediffv3_sdxl", "modelscopet2v", "latte"]`
  - Description: Select the base model to use.

- `--recall_timesteps`: Recall timesteps, you can choose one more than 1 for the complete SmoothInit.
  - Type: `int`
  - Default: `1`

- `--noise_type`: Type of noise, choose from `gaussian` and `uniform`.
  - Type: `str`
  - Default: `gaussian`

- `--ensemble`: The iteration number $K$ in the paper.
  - Type: `int`
  - Default: `20`

- `--momentum`: the decay rate $\gamma_\mathrm{decay}$ in the paper.
  - Type: `float`
  - Default: `0.15`

- `--traj_momentum`: the momentum $\gamma_\mathrm{m}$ in the paper.
  - Type: `float`
  - Default: `0.05`

- `--ensemble_rate`: the noise level $\sigma_\mathrm{sm}$ in the paper.
  - Type: `float`
  - Default: `0.05`

- `--fast_ensemble`: Fast-SmoothInit or SmoothInit.
  - Type: `bool`
  - Default: `False`

- `--tag`: Tag.
  - Type: `str`
  - Default: ``
  - Description: Tag for marking the experiment.

These parameters can be passed to the `inference.py` script via the command line to adjust the model's behavior.