#!/bin/bash

#SBATCH --job-name=ddpm # Submit a job named "example"
#SBATCH --output=jh_logs/log_celeba.txt 

#SBATCH --partition=a100
#SBATCH --gres=gpu:1          # Use 1 GPU
#SBATCH --time=1-00:00:00        # d-hh:mm:ss 형식, 본인 job의 max time limit 지정
#SBATCH --mem=50G              # cpu memory size
#SBATCH --cpus-per-task=8       # cpu 개수

ml purge
ml cuda/11.3
eval "$(conda shell.bash hook)"
conda activate diffusers

export MODEL_NAME="google/ncsnpp-celebahq-256" #"google/ncsnpp-ffhq-256" #"google/ddpm-ema-celebahq-256" #"simlightvt/ddpm-celebahq-128"
export DATASET_NAME="mattymchen/celeba-hq" #"Norod78/Vintage-Faces-FFHQAligned" "cr7Por/ffhq_controlnet_5_2_23"
export OUTPUT_DIR="output/isno_ncsnpp_iso1e-3_nodecreasing_10step"

cat isno_submit_celeba256.sh

#accelerate launch --mixed_precision="fp16" --multi_gpu --main_process_port 29502 --config_file acc_config/4gpu.yaml train_unconditional.py \
accelerate launch --mixed_precision="fp16" --main_process_port 29502  train_unconditional.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --dataset_name=$DATASET_NAME \
  --use_ema \
  --resolution=256 --center_crop --random_flip \
  --train_batch_size=1 \
  --num_epochs=20 \
  --gradient_accumulation_steps=1 \
  --learning_rate=1e-05 \
  --lr_scheduler="constant" \
  --lr_warmup_steps=0 \
  --output_dir=$OUTPUT_DIR \
  --fid_stats_path="assets/stats/mattymchen_celeba.npz" \
  --split="train" \
  --lambda_iso=0.001 \
  --normal_p=0.5 \
  --metric_batch=64 \
  # --noG \
  # --timestep_weight \
  # --fid \
  # --ppl \
  # --subfolder \
  # --dists \
  # --resume_from_checkpoint="output/celebahq-3/checkpoint-120000" \
