## Build Environtment

We Recommend a python version `==3.8` and cuda version `==12.2`. Then build environment as follows:

```shell
conda create -n PyraMotion python==3.8
conda activate PyraMotion
# Install ffmpeg for media processing and libstdcxx-ng for rendering
conda install -c conda-forge libstdcxx-ng ffmpeg
# Install with pip:
cd <path>/PyraMotion
pip install -r requirements.txt
pip install 'git+https://github.com/facebookresearch/pytorch3d.git@stable'
```

## Download Weight & Dataset

The weights can be downloaded by 
```shell
git clone https://huggingface.co/Submission/PyraMotion
```
And the dataset can be downloaded from https://pantomatrix.github.io/BEAT-Dataset/

These weights and datasets should be organized as follows:

```text
<your root>/PyraMotion/
|-- BEAT2
|   |-- beat_english_v2.0.0/
...
|-- pretrained
|   |-- pyramotion.bin
|   |-- hands.bin
|   |-- face.bin
|   |-- foot.bin
|   |-- lowerfoot.bin
|   `-- upper.bin
|-- smplx_models
|   `-- smplx/SMPLX_NEUTRAL_2020.npz
`-- test_sequences
```

# Inference 

## Inference

Here is the command for running inference scripts under the path ```<your root>/PyraMotion/```, it will take around 1 min to generate motion. 

```shell
python ./PyraMotion/scripts/pyramotion_test.py --config ./PyraMotion/scripts/configs/pyramotion.yaml
```

