# Understanding the Evolution of the Neural Tangent Kernel at the Edge of Stability

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

>📋  Please install the required packaged listed in `requirements.txt`.

## Training and Calculating NTKs

To train the fully-connected network, ViT model (see Section 3.1 for details), VGG-11 (see Appendix A.2.1 for details) and calculate NTKs, please first specify the parameters `learning_rate` and `num_steps` (number of training steps) in files `ntk_fully_connected.py `, `ntk_vit.py` and `ntk_vgg.py` respectively, and then run:

```train
python ntk_fully_connected.py
python ntk_vit.py
python ntk_vgg.py
```

>📋 The dataset will be automatically downloaded when running the scripts.
>
>📋 After training, there will be three new folders named `fc_models_NTKs` , `vit_models_NTKs` and `vgg11_models_NTKs`. Subfolders which specify the learning rates will also be created. The scripts will store training losses every step and store models, NTKs and eigenvalues of NTKs every 20 steps to the corresponding folders.

## Calculating the Evolution of KTA

To calculate the evolution of KTA, in `kta_evolution.py`, please specify the model path and the learning rates under which you want to do calculation. Please also specify the starting steps and end steps for calculation and the random seeds of the saved models. For example, for the models under random seed 200 saved under `vit_models_NTKs`, if you want to calculate KTAs under learning rates 0.005, 0.01 and 0.02 from initialization to 740, 460, 400 steps, please change the corresponding parts in `kta_evolution.py` to

```python
path = './vit_models_NTKs/'
seed = 200
lr_list = [0.005,0.01,0.02]
start_step = [0,0,0]
final_step = [740,460,400]
```

Then run:

```eval
python kta_evolution.py
```

>📋 The scripts will plot the evolution of KTA under the hyperparameters you specify.
>

## Individual Eigenvector Target Alignment for the Final Models

To calculate the individual eigenvector target alignment for the final models, in `alignment_final_models.py`, please specify the model path and the learning rates under which you want to do calculation. Please also specify end steps of the final models and the random seeds of the saved models. For example, for the models under random seed 200 saved under `vit_models_NTKs`, if you want to do calculation under learning rates 0.005, 0.01 and 0.02 for the final models after 740, 460, 400 steps, please change the corresponding parts in `alignment_final_models.py` to

```python
path = './vit_models_NTKs/'
seed = 200
lr_list = [0.005,0.01,0.02]
final_step_list = [740, 460, 400]
```

Then run:

```eval
python alignment_final_models.py
```

>📋  The scripts will plot the normalized eigenvalues, the individual eigenvector target alignment and its cumulative summation under the hyperparameters you specify.

## Results

You will get similar figures to those in Section 3.1.