#!/usr/bin/env python3
"""
Test complex problem solving to verify the enhanced DCMN system works
"""

import os
import sys
from pathlib import Path

sys.path.append(str(Path(__file__).parent))

from neuro_symbolic_planner import NeuroSymbolicPlanner
from dcmn_causal_memory import integrate_dcmn_with_planner

def test_complex_problem():
    """Test complex multi-step problem"""
    
    print("=== TESTING COMPLEX PROBLEM SOLVING ===")
    
    api_key = os.getenv("GROQ_API_KEY", "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")
    
    # Complex task that should trigger all our enhancements
    complex_task = "Stack three blocks: put the red block on the blue block, then put the green block on top of the red block"
    
    print(f"\nComplex Task: {complex_task}")
    print("="*70)
    
    try:
        planner = NeuroSymbolicPlanner(api_key)
        planner = integrate_dcmn_with_planner(planner)
        
        # Test with increased iterations for complex task
        result = planner.plan_from_natural_language(complex_task, max_iterations=5)
        
        print(f"\nRESULT:")
        print(f"Success: {result.success}")
        print(f"Plan: {result.plan}")
        print(f"Iterations: {result.iterations}")
        print(f"Confidence: {result.confidence_score:.2f}")
        print(f"Time: {result.total_time:.2f}s")
        
        if result.explanations:
            print(f"\nExplanations:")
            for i, exp in enumerate(result.explanations):
                print(f"  {i+1}. {exp}")
        
        if result.success:
            print("\n✅ COMPLEX PROBLEM SOLVING: SUCCESS")
            return True
        else:
            print("\n❌ COMPLEX PROBLEM SOLVING: FAILED")
            return False
            
    except Exception as e:
        print(f"❌ Error: {e}")
        import traceback
        traceback.print_exc()
        return False

if __name__ == "__main__":
    test_complex_problem()