from http import HTTPStatus
import os
import copy as cp
from vlmeval.api.base import BaseAPI
from vlmeval.smp import *
import dashscope


# Note: This is a pure language model API.
class QwenAPI(BaseAPI):

    is_api: bool = True

    def __init__(self,
                 model: str = 'qwen-max-1201',
                 retry: int = 5,
                 wait: int = 5,
                 verbose: bool = False,
                 seed: int = 8196,
                 temperature: float = 0.0,
                 system_prompt: str = None,
                 key: str = None,
                 max_tokens: int = 2048,
                 proxy: str = None,
                 enable_thinking: bool = True,
                 **kwargs):

        # assert model in ['qwen-turbo', 'qwen-plus', 'qwen-max', 'qwen-max-1201', 'qwen-max-longcontext']
        self.model = model
        self.enable_thinking = enable_thinking
        import dashscope
        self.fail_msg = 'Failed to obtain answer via API. '
        self.max_tokens = max_tokens
        self.temperature = temperature
        self.seed = seed
        if key is None:
            key = os.environ.get('DASHSCOPE_API_KEY', None)
        assert key is not None, (
            'Please set the API Key (obtain it here: '
            'https://help.aliyun.com/zh/dashscope/developer-reference/vl-plus-quick-start)'
        )
        dashscope.api_key = key
        if proxy is not None:
            proxy_set(proxy)
        super().__init__(wait=wait, retry=retry, system_prompt=system_prompt, verbose=verbose, **kwargs)

    @staticmethod
    def build_msgs(msgs_raw, system_prompt=None):
        msgs = cp.deepcopy(msgs_raw)
        ret = []
        if system_prompt is not None:
            ret.append(dict(role='system', content=system_prompt))
        for i, msg in enumerate(msgs):
            role = 'user' if i % 2 == 0 else 'assistant'
            ret.append(dict(role=role, content=msg))
        return ret

    def generate_inner(self, inputs, **kwargs) -> str:
        import dashscope
        if 'pre' in self.model:
            dashscope.base_http_api_url = 'https://poc-dashscope.aliyuncs.com/api/v1' #'https://poc-dashscope.aliyuncs.com/api/v1'
            dashscope.base_websocket_api_url= 'https://poc-dashscope.aliyuncs.com/api/v1/services/aigc/multimodal-generation/generation'
        else:
            dashscope.base_http_api_url = 'https://dashscope.aliyuncs.com/api/v1'
            dashscope.base_websocket_api_url= 'wss://dashscope.aliyuncs.com/api-ws/v1/inference'

        assert isinstance(inputs, str) or isinstance(inputs, list)
        inputs = [inputs] if isinstance(inputs, str) else inputs
        messages = self.build_msgs(msgs_raw=inputs, system_prompt=self.system_prompt)

        # response = dashscope.Generation.call(
        #     model=self.model,
        #     messages=messages,
        #     seed=self.seed,
        #     temperature=self.temperature,
        #     max_tokens=self.max_tokens,
        #     result_format='message',  # set the result to be "message" format.
        # )

        response = dashscope.Generation.call(
            model=self.model,
            messages=messages,
            seed=self.seed,
            temperature=self.temperature,
            max_tokens=self.max_tokens,
            result_format="message", # Qwen3开源版模型只支持设定为"message"；为了更好的体验，其它模型也推荐您优先设定为"message"
            # 开启深度思考，该参数对 QwQ、DeepSeek-R1 模型无效
            enable_thinking=self.enable_thinking,
            stream=True,
            incremental_output=True, # Qwen3开源版模型只支持 true；为了更好的体验，其它模型也推荐您优先设定为 true
        )

        # 定义完整思考过程
        reasoning_content = ""# 定义完整回复
        answer_content = ""# 判断是否结束思考过程并开始回复
        is_answering = False
        if self.verbose:
            print("=" * 20 + "思考过程" + "=" * 20)

        for chunk in response:
            if 'qwen3' in self.model or 'qwq' in self.model:
                # 如果思考过程与回复皆为空，则忽略
                if (
                    chunk.output.choices[0].message.content == ""
                    and chunk.output.choices[0].message.reasoning_content == ""
                ):
                    pass
                else:
                        # 如果当前为思考过程
                    if (
                        chunk.output.choices[0].message.reasoning_content != ""
                        and chunk.output.choices[0].message.content == ""
                    ):
                        if self.verbose:
                            print(chunk.output.choices[0].message.reasoning_content, end="", flush=True)
                        reasoning_content += chunk.output.choices[0].message.reasoning_content
                    # 如果当前为回复
                    elif chunk.output.choices[0].message.content != "":
                        if not is_answering:
                            if self.verbose:
                                print("\n" + "=" * 20 + "完整回复" + "=" * 20)
                            is_answering = True
                        if self.verbose:
                            print(chunk.output.choices[0].message.content, end="", flush=True)
                        answer_content += chunk.output.choices[0].message.content
            else:
                if chunk.output.choices[0].message.content != "":
                    if not is_answering:
                        if self.verbose:
                            print("\n" + "=" * 20 + "完整回复" + "=" * 20)
                        is_answering = True
                    if self.verbose:
                        print(chunk.output.choices[0].message.content, end="", flush=True)
                    answer_content += chunk.output.choices[0].message.content

        # 如果您需要打印完整思考过程与完整回复，请将以下代码解除注释后运行# print("=" * 20 + "完整思考过程" + "=" * 20 + "\n")# print(f"{reasoning_content}")# print("=" * 20 + "完整回复" + "=" * 20 + "\n")# print(f"{answer_content}")

        # if response.status_code != HTTPStatus.OK:
        #     print(response)
        #     return -1, 'Error: Bad Response Statuse Code. ', f'The response status code is {response.status_code}. '

        try:
            return 0, answer_content.strip(), 'Succeeded! '
        except Exception as err:
            return -1, f'Error: Failed to parse the response. {err}', response

class Qwen2API(BaseAPI):

    is_api: bool = True

    def __init__(self,
                 model: str = 'qwen-max-1201',
                 retry: int = 5,
                 wait: int = 5,
                 verbose: bool = False,
                 seed: int = 8196,
                 temperature: float = 0.0,
                 system_prompt: str = None,
                 key: str = None,
                 max_tokens: int = 2048,
                 proxy: str = None,
                 **kwargs):

        # assert model in ['qwen-turbo', 'qwen-plus', 'qwen-max', 'qwen-max-1201', 'qwen-max-longcontext']
        self.model = model
        import dashscope
        self.fail_msg = 'Failed to obtain answer via API. '
        self.max_tokens = max_tokens
        self.temperature = temperature
        self.seed = seed
        if key is None:
            key = os.environ.get('DASHSCOPE_API_KEY', None)
        assert key is not None, (
            'Please set the API Key (obtain it here: '
            'https://help.aliyun.com/zh/dashscope/developer-reference/vl-plus-quick-start)'
        )
        dashscope.api_key = key
        if proxy is not None:
            proxy_set(proxy)
        super().__init__(wait=wait, retry=retry, system_prompt=system_prompt, verbose=verbose, **kwargs)

    @staticmethod
    def build_msgs(msgs_raw, system_prompt=None):
        msgs = cp.deepcopy(msgs_raw)
        ret = []
        if system_prompt is not None:
            ret.append(dict(role='system', content=system_prompt))
        for i, msg in enumerate(msgs):
            role = 'user' if i % 2 == 0 else 'assistant'
            ret.append(dict(role=role, content=msg))
        return ret

    def generate_inner(self, inputs, **kwargs) -> str:
        import dashscope
        if 'pre' in self.model:
            dashscope.base_http_api_url = 'https://poc-dashscope.aliyuncs.com/api/v1' #'https://poc-dashscope.aliyuncs.com/api/v1'
            dashscope.base_websocket_api_url= 'https://poc-dashscope.aliyuncs.com/api/v1/services/aigc/multimodal-generation/generation'
        else:
            dashscope.base_http_api_url = 'https://dashscope.aliyuncs.com/api/v1'
            dashscope.base_websocket_api_url= 'wss://dashscope.aliyuncs.com/api-ws/v1/inference'

        assert isinstance(inputs, str) or isinstance(inputs, list)
        inputs = [inputs] if isinstance(inputs, str) else inputs
        messages = self.build_msgs(msgs_raw=inputs, system_prompt=self.system_prompt)

        # response = dashscope.Generation.call(
        #     model=self.model,
        #     messages=messages,
        #     seed=self.seed,
        #     temperature=self.temperature,
        #     max_tokens=self.max_tokens,
        #     result_format='message',  # set the result to be "message" format.
        # )

        response = dashscope.Generation.call(
            model=self.model,
            messages=messages,
            seed=self.seed,
            temperature=self.temperature,
            max_tokens=self.max_tokens,
            result_format="message", # Qwen3开源版模型只支持设定为"message"；为了更好的体验，其它模型也推荐您优先设定为"message"
            # 开启深度思考，该参数对 QwQ、DeepSeek-R1 模型无效
            # enable_thinking=True,
            stream=True,
            incremental_output=True, # Qwen3开源版模型只支持 true；为了更好的体验，其它模型也推荐您优先设定为 true
        )
        # # 按状态码判断是否成功
        # if response.status_code == HTTPStatus.OK:
        # try:
        #     print(response.message)
        content = response.output.choices[0].message.content
        
        if self.verbose:
            print(f"[QwenAPI 返回成功] {content}")
        return 0, content.strip(), 'Succeeded!'
        # except Exception as e:
        #     return -1, f"Error: Failed to parse the response. {e}", response
        # else:
        #     # 打印详细错误
        #     err_msg = (
        #         f"HTTP返回码：{response.status_code}\n"
        #         f"错误码：{getattr(response, 'code', None)}\n"
        #         f"错误信息：{getattr(response, 'message', None)}\n"
        #         "请参考文档：https://help.aliyun.com/zh/model-studio/developer-reference/error-code"
        #     )
        #     if self.verbose:
        #         print(err_msg)
        #     return -1, err_msg, response