# Highly Efficient Self-Adaptive Reward Shaping for Reinforcement Learning (SASR)

The codes for our proposed **S**elf-**A**daptive **S**uccess **R**ate based reward shaping algorithm (SASR) for reinforcement learning to tackle the sparse-reward challenge.

The principles of the SASR mechanism is shown as follows, inspired by the Thompson sampling, we use an evolving Beta distribution to sample estimated success rate for each state as the shaped reward.

![The principles of the SASR mechanism.](./readme-images/framework.png)

## Requirements

- This code has been tested on:

```
pytorch==2.0.1+cu117
```

- Install all dependent packages:

```
pip3 install -r requirements.txt
```

## Run SASR Algorithm

Run the following command to run SASR algorithm on the task specified by `<Task ID>`:

```
python run-SASR.py --env-id <Task ID>
```

All available environments with sparse rewards evaluated in our paper are listed below:

![All available environments with sparse rewards](./readme-images/environments.png)

* Mujoco-Sparse:
    - `MyMujoco/Ant-Height-Sparse`: the *AntStand* task.
    - `MyMujoco/Ant-Far-Sparse`: the *AntFar* task.
    - `MyMujoco/HumanoidStandup-Sparse`: the *HumanStand* task.
    - `MyMujoco/Humanoid-Keep-Sparse`: the *HumanKeep* task.
* Robotics-Sparse:
    - `MyFetchRobot/Reach-Jnt-Sparse-v0`: the *RobotReach* task.
    - `MyFetchRobot/Push-Jnt-Sparse-v0`: the *RobotPush* task.
    - `MyFetchRobot/Slide-Jnt-Sparse-v0`: the *RobotSlide* task.
    - `MyFetchRobot/PickAndPlace-Jnt-Sparse-v0`: the *RobotPickPlace* task.
* Atari games:
    - `Pitfall-v4`: the *Pitfall* task.
    - `MontezumaRevenge-v4`: the *MontezumaRevenge* task.
    - `Frogger-v4`: the *Frogger* task.
    - `Solaris-v4`: the *Solaris* task.
    - `Freeway-v4`: the *FreeWay* task.
* Physical simulation tasks:
    - `MountainCarContinuous-v0`: the *MountainCar* task.

All hyper-parameters are set as default values in the code. You can change them by adding arguments to the command line. All available arguments are listed below:

```
--exp-name: the name of the experiment, to record the tensorboard and save the model.
--env-id: the task id
--seed: the random seed.
--cuda: the cuda device, default is 0, the code will automatically choose "cpu" if cuda is not available.
--gamma: the discount factor.

--pa-buffer-size: the buffer size to replay experiences.
--rb-optimize-memory: whether to optimize the memory
--batch-size: the batch size

--actor-lr: the learning rate of the actor
--critic-lr: the learning rate of the critic
--alpha: the alpha to balance the maximum entropy term
--alpha-autotune: whether to autotune the alpha, default is True
--alpha-lr: the learning rate of the alpha

--target-frequency: the target network update frequency
--tau: the tau for the soft update of the target network
--policy-frequency: the policy network update frequency

--total-timesteps: the total timesteps to train the model
--learning-starts: the burn-in period to start learning

--reward-weight: the weight factor of the shaped reward
--kde-bandwidth: the bandwidth of the kernel density estimation
--kde-sample-burnin: the burn-in period to sample the KDE
--rff-dim: the dimension of the random Fourier features, if set to None, then only use KDE (w/o RFF)
--retention-rate: the retention rate

--write-frequency: the frequency to write the tensorboard
--save-folder: the folder to save the model
```

## Experimental Results

We compared SASR with several baselines, including DRND (Yang et al., 2024), ReLara (Ma et al., 2024), GFA-RFE (Zhang et al., 2024), ROSA (Mguni et al., 2023), ExploRS (Devidze et al., 2022), #Explo (Tang et al., 2017), RND (Burda et al., 2018), SAC (Haarnoja et al., 2018), TD3 (Fujimoto et al., 2018), and PPO (Schulman et al., 2017). The comparison results are shown as follows:

![Comparison of the learning performance of SASR with the baselines.](./readme-images/comparison.png)

## Citiation

If you find this code useful, please cite our paper:

```
@inproceedings{ma2025,
  title={Highly efficient self-adaptive reward shaping for reinforcement learning},
  author={Ma, Haozhe and Luo, Zhengding and Vo, Thanh Vinh and Sima, Kuankuan and Leong, Tze-Yun},
  booktitle={International Conference on Learning Representations},
  year={2025},
}
```