#!/bin/bash

SPLIT="mmbench_dev_20230712"

$SCRATCH/code/super_mllm/pytorch-example/python -m llava.eval.model_vqa_mmbench \
    --model-path ./checkpoints/llava-v1.7-7b-patch \
    --question-file $VAST/eval/mmbench/$SPLIT.tsv \
    --answers-file $VAST/eval/mmbench/answers/$SPLIT/llava-v1.7-7b-patch.jsonl \
    --single-pred-prompt \
    --temperature 0 \
    --conv-mode vicuna_v1

mkdir -p playground/data/eval/mmbench/answers_upload/$SPLIT

$SCRATCH/code/super_mllm/pytorch-example/python scripts/convert_mmbench_for_submission.py \
    --annotation-file $VAST/eval/mmbench/$SPLIT.tsv \
    --result-dir $VAST/eval/mmbench/answers/$SPLIT \
    --upload-dir $VAST/eval/mmbench/answers_upload/$SPLIT \
    --experiment llava-v1.7-7b-patch
