# Training-Free Safe Denoisers for Safe Use of Diffusion Models

# Setup

## Install Dependencies

1. (Optional) Creating conda environment

```bash
conda create -n SAFER python=3.10.13
conda activate SAFER
```

2. build from source

```bash
pip install -r requirements.txt
```

### Nudity {Ring-A-Bell, UnlearnDiff, MMA-Diffusion}
- Ring-A-Bell 
```bash
python generate_nudity.py --nudenet-path=pretrained/classifier_model.onnx --nudity_thr=0.6 --config=configs/base/vanilla/safree_neg_prompt_config.json --data=datasets/nudity-ring-a-bell.csv --category=nudity --task_config=configs/safree_safer.yaml --save-dir=results/safree_safer --erase_id=safree_neg_prompt_safer
```
- Unlearndiff
```bash
python generate_nudity.py --nudenet-path=pretrained/classifier_model.onnx --nudity_thr=0.6 --config=configs/base/vanilla/safree_neg_prompt_config.json --data=datasets/nudity.csv --category=nudity --task_config=configs/safree_safer.yaml --save-dir=results/safree_safer --erase_id=safree_neg_prompt_safer
```

- MMA-Diffusion
```bash
python generate_nudity.py --nudenet-path=pretrained/classifier_model.onnx --nudity_thr=0.6 --config=configs/base/vanilla/safree_neg_prompt_config.json --data=datasets/mma-diffusion-nsfw-adv-prompts.csv --category=nudity --task_config=configs/safree_safer.yaml --save-dir=results/safree_safer --erase_id=safree_neg_prompt_safer
```

### CoCo30-K

```bash
python generate_coco30k.py --nudenet-path=pretrained/classifier_model.onnx --nudity_thr=0.6 --config=configs/base/vanilla/safree_neg_prompt_config.json --category=coco --task_config=configs/safree_safer.yaml --save-dir=results/safree_safer --erase_id=safree_neg_prompt_safer
```
### Ann Graham Lotz

```bash
python generate_ann_graham.py --nudenet-path=pretrained/classifier_model.onnx --nudity_thr=0.6 --config=configs/base/vanilla/safree_neg_prompt_config.json --category=artists-AnnGrahamLotz --task_config=configs/safree_safer_ann.yaml --save-dir=results/safree_safer --erase_id=safree_neg_prompt_safer
```
