import pickle
import numpy as np 
noise_type_all = ['interp']
model_name = 'mpsn'
nonlinear_list = ['_tanh_no_readout']
# '_id','_id_no_readout','_tanh','_tanh_no_readout'
layers = 1
K1=3
K2=3
K=1
hidden_features_all = [1,16,64]
prefix = './final_results/'
for noise_type in noise_type_all:
    if model_name == 'scnn':
        for affix in nonlinear_list:
            folder = prefix + noise_type + '_noise/'+model_name
            folder = folder + affix 
            error_mean,error_std = np.empty((6,3,6,6)),np.empty((6,3,6,6))
            curl_mean,curl_std = np.empty((6,3,6,6)),np.empty((6,3,6,6))
            for layers in range(6):
                for hh in range(len(hidden_features_all)):
                    hidden_features = int(hidden_features_all[hh])
                    for K1 in range(6):
                        for K2 in range(6):
                            path = folder + '/%dlayers_%d_%dorders_%dfeatures'%(layers,K1,K2,hidden_features) 
                            f_results =  open(path+'.pkl','rb')
                            all_errors,all_curls = pickle.load(f_results)
                            error_mean[layers,hh,K1,K2],error_std[layers,hh,K1,K2] = np.round(np.mean(all_errors),3),np.round(np.std(all_errors),3)
                            curl_mean[layers,hh,K1,K2],curl_std[layers,hh,K1,K2] = np.round(np.mean(all_curls),3),np.round(np.std(all_curls),3)
                    print(folder+str(layers)+'layer'+str(hidden_features)+'features \n')
                    print(np.round(error_mean[layers,hh,:,:],3),'\n')
                    # print(np.round(error_std[layers,hh,:,:],3))
                    print(np.round(curl_mean[layers,hh,:,:],3))
                    # print(np.round(curl_std[layers,hh,:,:],3))
                    
    elif model_name == 'mpsn':
        for affix in ['_id_','_tanh_','_relu_']:
            for aggregation in ['mean','sum']:
                folder = prefix + noise_type + '_noise/'+model_name
                folder = folder + affix 
                folder = folder+aggregation
                error_mean,error_std = np.empty((6,3)),np.empty((6,3))
                curl_mean,curl_std = np.empty((6,3)),np.empty((6,3))
                for layers in range(6):
                    for hh in range(len(hidden_features_all)):
                        hidden_features = hidden_features_all[hh]
                        path = folder+'/%s_%dlayers_%dfeatures'%(aggregation,layers,hidden_features)
                        f_results =  open(path+'.pkl','rb')
                        
                        all_errors,all_curls = pickle.load(f_results)
                        error_mean[layers,hh],error_std[layers,hh] = np.round(np.mean(all_errors),3),np.round(np.std(all_errors),3)
                        curl_mean[layers,hh],curl_std[layers,hh] = np.round(np.mean(all_curls),3),np.round(np.std(all_curls),3)
                        print(folder+str(layers)+'layer'+str(hidden_features)+'features \n',np.round(error_mean[layers,hh],3),u"\u00B1",np.round(error_std[layers,hh],3), np.round(curl_mean[layers,hh],3),u"\u00B1",np.round(curl_std[layers,hh],3))
                        
    elif model_name == 'psnn':
        for affix in nonlinear_list:
            folder = prefix + noise_type + '_noise/'+model_name
            folder = folder + affix 
            error_mean,error_std = np.empty((6,3)),np.empty((6,3))
            curl_mean,curl_std = np.empty((6,3)),np.empty((6,3))
            for layers in range(6):
                for hh in range(len(hidden_features_all)):
                    hidden_features = int(hidden_features_all[hh])
                    path = folder + '/%dlayers_%dfeatures'%(layers,hidden_features) 
                    try: 
                        f_results =  open(path+'.pkl','rb')
                        all_errors,all_curls = pickle.load(f_results)
                        error_mean[layers,hh],error_std[layers,hh] = np.round(np.mean(all_errors),3),np.round(np.std(all_errors),3)
                        curl_mean[layers,hh],curl_std[layers,hh] = np.round(np.mean(all_curls),3),np.round(np.std(all_curls),3)
                        print(folder+str(layers)+'layer'+str(hidden_features)+'features \n',np.round(error_mean[layers,hh],3),u"\u00B1",np.round(error_std[layers,hh],3), np.round(curl_mean[layers,hh],3),u"\u00B1",np.round(curl_std[layers,hh],3))
                    except FileNotFoundError:
                        print('an error occurred while fetching')
                        continue
                    
    elif model_name == 'snn':
        for affix in nonlinear_list:
            folder = prefix + noise_type + '_noise/'+model_name
            folder = folder + affix 
            error_mean,error_std = np.empty((6,3,6)),np.empty((6,3,6))
            curl_mean,curl_std = np.empty((6,3,6)),np.empty((6,3,6))
            for layers in range(6):
                for hh in range(len(hidden_features_all)):
                    hidden_features = int(hidden_features_all[hh])
                    for K in range(6):
                        path = folder + '/%dlayers_%dorders_%dfeatures'%(layers,K,hidden_features) 
                        f_results =  open(path+'.pkl','rb')
                        all_errors,all_curls = pickle.load(f_results)
                        error_mean[layers,hh,K],error_std[layers,hh,K] = np.round(np.mean(all_errors),3),np.round(np.std(all_errors),3)
                        curl_mean[layers,hh,K],curl_std[layers,hh,K] = np.round(np.mean(all_curls),3),np.round(np.std(all_curls),3)
                    print(folder+str(layers)+'layer'+str(hidden_features)+'features \n')
                    print(np.round(error_mean[layers,hh,:],3))
                    print(np.round(error_std[layers,hh,:],3))
                    print(np.round(curl_mean[layers,hh,:],3))
                    print(np.round(curl_std[layers,hh,:],3))
