# Forex Reconstruction -- Hogde-Aware Learning on Simplicial Complexes
[Semantic Scholar]:https://www.semanticscholar.org/
[Bunch Model]:https://arxiv.org/abs/2012.06010
[SNN]:https://arxiv.org/abs/2010.03633
[PSNN]:https://arxiv.org/abs/2102.10058
[SCNN]:https://ieeexplore.ieee.org/abstract/document/9746017?casa_token=QR4DA8Bju5QAAAAA:xDc2i3Bw7eHtr15KaL1JzWlJEpEnmNHpekuWg5b-aWqVkFnjHCDL9lmPZ3TvG5kdWZAhrCod1w
[GNN]:https://arxiv.org/abs/1606.09375
[CF-SC]:https://arxiv.org/abs/2201.12584
[SCF]:https://arxiv.org/abs/2201.11720
[Benson 2018]: https://arxiv.org/abs/1802.06916

This is a README file for the task of simplex prediction base on the SCCNN. 


# Training
To train SCCNN, which is essentially SCNN since there is no inter-simplicial couplings here 
```sh
# train scnn for random or curl noise
sh ./scripts/run_scnn.sh --noise_type [random/curl]
```
Trained models are saved in [model_nn](./model_nn/) and loss files are saved in [loss_files](./loss_files/)

```sh
# train scnn for interpolation
sh ./scripts/run_scnn_interp.sh --noise_type [interp]
``` 

To train MPSN
```sh
# train mpsn 
sh ./scripts/run_mpsn.sh # 
```
To train PSNN model 
```sh
# train psnn 
sh ./scripts/run_psnn.sh # 
```

To run baseline method
```py
python ./forex_denoise_tikhonov.py # 
python ./forex_interp_tikhonov.py # 
```

## Data
Forex data and the boundaries matrices for the SC are stored in [data](./data/)

## Model 
Models are written in [model](./model/)

## Results 
Results over ten runs are stored in [final_results](./final_results)