import os
import time
import argparse

def get_parser():
    '''
    hyperparameter
    '''
    parser = argparse.ArgumentParser()
    parser.add_argument("-hd", "--hidden_features", help="the number of hidden features", type=int, default=64)
    parser.add_argument("-m","--model_name",help="the model name", type=str, default='psnn')
    parser.add_argument("-l", "--layers", help="the number of layers", type=int, default=5) # note that here it is the number of intermediate layers
    parser.add_argument("-k","--filter_order_snn",help="the filter order of the model snn", type=int, default=2)
    parser.add_argument("-k1","--filter_order_scnn_k1",help="the filter order of the model scnn", type=int, default=2)
    parser.add_argument("-k2","--filter_order_scnn_k2",help="the filter order of the model scnn", type=int, default=2)
    parser.add_argument('-lr',"--learning_rate",help="learning rate of adam", default=0.001)
    parser.add_argument('-e',"--epochs",help="number of epochs", type=int, default=1000)
    parser.add_argument("-a_update", "--activations_update", help="activation function", type=str, default='elu')
    parser.add_argument("-agg", "--aggregation", help="activation function", type=str, default='mean') # 'sum', 'mean', 'max'
    parser.add_argument("-a", "--activations", help="activation function", type=str, default='tanh')
    parser.add_argument("-rlz", "--realizations", help="total number of realizations", type=int, default=10)
    parser.add_argument("-noise", "--noise_type", help="random,curl or gradient noise", type=str, default='random')  # 'curl' or 'random' or 'interp'
    parser.add_argument("-decoder", "--mlp_decoder", help="if to add an mlp decoder as readout",type=str,default='False') # 'True' for random or 'False' for curl 
    parser.add_argument("-snr", "--snr", help="noise level",   default=-3)   
    return parser 