export ct=4.0
export cb=3.6
export pt=4.0
export pb=4.8
export epoch=100
export alpha=0.5
export out_root_dir=results
export mode=student
export lr=0.0
export cuda=3
export data_id=Set1
export pri_name=Gumbel
export pri_name=preserve_linear_gumbel
export loss_fn=RankBCE
export qg_mask=1 # 1 means negative query group removed for data loss and teacher training. 0 means using all query groups.


###############
# main result #
###############
for data_id in Set1 Istella
do
    python json_generator.py --mode student --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --repeat 0
    python augmented_data_generation.py -dir_json ./
    rm ./Data_Eval_ScoringFunction.json
    for repeat_id in 0 1 2 3 4
    do
        for loss_fn in RankBCE RankNet
        do
            for mode in student teacher LUPI_teacher
            do
                python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                rm ./Data_Eval_ScoringFunction.json
            done

            for alpha in 0.5
            do
                for mode in distillation selfdist LUPI_dist
                do
                    python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                    python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                    rm ./Data_Eval_ScoringFunction.json
                done
            done
        done
    done
done

for data_id in MSLRWEB30K
do
    python json_generator.py --mode student --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --repeat 0
    python augmented_data_generation.py -dir_json ./
    rm ./Data_Eval_ScoringFunction.json
    for repeat_id in 0
    do
        for loss_fn in RankBCE RankNet
        do
            for mode in student teacher LUPI_teacher
            do
                python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                rm ./Data_Eval_ScoringFunction.json
            done

            for alpha in 0.5
            do
                for mode in selfdist distillation LUPI_dist
                do
                    python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                    python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                    rm ./Data_Eval_ScoringFunction.json
                done
            done
        done
    done
done


################################
# Ablation: query group filter #
################################

export ct=4.0
export cb=3.6
export pt=4.0
export pb=4.8
for data_id in Set1
do
    python json_generator.py --mode student --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --repeat 0
    python augmented_data_generation.py -dir_json ./
    rm ./Data_Eval_ScoringFunction.json
    for repeat_id in 0 1 2 3 4
    do
        for loss_fn in RankBCE
        do
            for qg_mask in 0 1
            do
                for mode in teacher
                do
                    python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                    python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                    rm ./Data_Eval_ScoringFunction.json
                done
                for mode in distillation
                do
                    python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                    python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                    rm ./Data_Eval_ScoringFunction.json
                done
            done
        done
    done
done


# ###################
# # ablation: alpha #
# ###################

for data_id in Set1
do
    python json_generator.py --mode student --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --repeat 0
    python augmented_data_generation.py -dir_json ./
    rm ./Data_Eval_ScoringFunction.json
    for repeat_id in 0 1 2 3 4
    do
        for loss_fn in RankBCE
        do
            for mode in student teacher
            do
                python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                rm ./Data_Eval_ScoringFunction.json
            done

            for alpha in 0.0 0.3 0.5 0.7 0.9 0.95 0.97 0.99 0.996 0.999 0.9999 1.0
            do
                for mode in distillation
                do
                    python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                    python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                    rm ./Data_Eval_ScoringFunction.json
                done
            done
        done
    done
done


# ######################
# # Ablation: sparsity #
# ######################

export loss_fn=RankBCE
for data_id in Set1
do
    python json_generator.py --mode student --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --repeat 0
    python augmented_data_generation.py -dir_json ./
    rm ./Data_Eval_ScoringFunction.json
    for repeat_id in 0 1 2 3 4
    do
        for pb in 4.8 4.4 4.0 3.6 3.2 2.8 2.4 2.0 1.6 1.2 0.8
        do
            for mode in student teacher
            do
                python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                rm ./Data_Eval_ScoringFunction.json
            done

            for alpha in 0.5
            do
                for mode in selfdist distillation
                do
                    python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                    python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                    rm ./Data_Eval_ScoringFunction.json
                done
            done
        done
    done
done

#########################
# Ablation: correlation #
#########################

export loss_fn=RankBCE
export pri_name=Gumbel
export pb=4.8

for data_id in Set1
do
    python json_generator.py --mode student --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --repeat 0
    python augmented_data_generation.py -dir_json ./
    rm ./Data_Eval_ScoringFunction.json
    for repeat_id in 0 1 2 3 4
    do
        for mode in student
        do
            export cb=3.6
            python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
            python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
            rm ./Data_Eval_ScoringFunction.json
        done
        for cb in 1.8 2.4 3.0 3.6 4.2 4.4 4.6 4.7 4.8
        do
            for mode in teacher
            do
                python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                rm ./Data_Eval_ScoringFunction.json
            done

            for alpha in 0.5
            do
                for mode in distillation
                do
                    python json_generator.py --mode $mode --ct $ct --pt $pt --cb $cb --pb $pb --epoch $epoch --alpha $alpha --data_id $data_id --loss_fn $loss_fn --out_root_dir $out_root_dir --lr $lr --repeat $repeat_id --pri_name $pri_name --qg_mask $qg_mask
                    python pt_ranking.py -cuda $cuda -model $loss_fn -dir_json ./ -seed $repeat_id
                    rm ./Data_Eval_ScoringFunction.json
                done
            done
        done
    done
done


