# File: pivotAlg.py
# This file contains the implementation of the pivot algorithm, whose approximation ratio is 3 + \eps.

from utils import *

class PivotAlgorithm:
    
    def __init__(self, vertices_num, k):
        self.vertices_num = vertices_num

        # Initialize the truncated priority queues of each vertex
        self.Q = [TruncatedPriorityQueue(k) for _ in range(vertices_num)]
        for i in range(vertices_num):
            self.Q[i].push(item=i, priority=i + 1)

    def run(self, streaming_edges_file, output_file):
        # Permute the vertices to get a random order
        self.permutator = Vertexpermutator(self.vertices_num)

        # Read the streaming edges and update the truncated priority queues
        self.read_stream(streaming_edges_file)

        # Post-process and output the final clustering result
        post_process(self.vertices_num, self.Q, self.permutator, output_file)

    def read_stream(self, streaming_edges_file):
        with open(streaming_edges_file, 'r') as f:
            f.readline()
            for line in f:
                u, v, label = line.strip().split()
                u, v = self.permutator.get_permuted_vertexID(int(u)), self.permutator.get_permuted_vertexID(int(v))

                if label == '+':
                    self.Q[u].push(item=v, priority=v + 1)
                    self.Q[v].push(item=u, priority=u + 1)