import os 
import shutil
import string
import subprocess
import random
import json
from typing import Callable, List
import glob
import time


TEMP_DIRECTORIES_ROOT = 'temp_directories_for_blip_vqa_evaluation'

def make_temp_directories():
    examples_dir_path = ''.join(random.choices(string.ascii_lowercase + string.digits, k=40)) + str(int(time.time() * 1000))
    examples_dir_path = os.path.join(TEMP_DIRECTORIES_ROOT, examples_dir_path)
    
    if os.path.exists(examples_dir_path):
        raise Exception("Something pretty rare happened!!!") # TODO: Handle this case

    samples_dir_path = os.path.join(examples_dir_path, 'samples')
    os.makedirs(samples_dir_path)

    return examples_dir_path, samples_dir_path


def evaluate_direcotry_using_blip_vqa(
        image_folder_path: str,
        print_log: bool = True
    ):
    assert os.path.exists(image_folder_path)
    image_folder_path = os.path.abspath(image_folder_path)

    images_in_folder_pattern = os.path.join(image_folder_path, '*.png')
    list_of_images = glob.glob(images_in_folder_pattern)

    if print_log:
        print(f"Evaluating {len(list_of_images)} images")
        
    examples_dir_path, samples_dir_path = make_temp_directories()

    for imgpath in list_of_images:
        shutil.copy2(imgpath, samples_dir_path)

    subprocess.call(["./test.sh", os.path.abspath(examples_dir_path)])

    question_id_score_dict = {}
    with open(os.path.join(examples_dir_path, 'annotation_blip/vqa_result.json')) as f:
        vqa_result_json = json.load(f)
        for item in vqa_result_json:
            question_id_score_dict[item["question_id"]] = item["answer"]

    image_scores_dict = {}
    with open(os.path.join(examples_dir_path, 'annotation1_blip/vqa_test.json')) as f:
        vqa_test_json = json.load(f)
        for item in vqa_test_json:
            image_scores_dict[os.path.basename(item['image'])] = question_id_score_dict[item['question_id']]

    assert len(image_scores_dict) == len(list_of_images)
    assert set(image_scores_dict.keys()) == set([os.path.basename(f) for f in list_of_images])

    shutil.rmtree(examples_dir_path)

    result_path = os.path.join(image_folder_path, 'vqa_result.json')
    if os.path.exists(result_path) and print_log:
        print("Rewriting results of VQA")
    with open(result_path, 'w') as f:
        json.dump(image_scores_dict, f)
    
    return image_scores_dict
    

if __name__ == '__main__':
    evaluate_direcotry_using_blip_vqa('./examples2') # TODO: Remove
